/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.udt;

import com.yashandb.Session;
import com.yashandb.core.DataType;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataImpl;
import com.yashandb.jdbc.YasRowID;
import com.yashandb.jdbc.YasType;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.protocol.accessor.UdtAccessor;
import com.yashandb.udt.AbstractUDT;
import com.yashandb.udt.YasArrayDataResultSet;
import com.yashandb.udt.YasStruct;
import com.yashandb.udt.YasTypeDescriptor;
import com.yashandb.udt.YasUdtSerializer;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.util.Arrays;
import java.util.Map;

public class YasArray
extends AbstractUDT
implements Array {
    private String elementTypeName;
    private int elementTypeCode;
    private Object[] elements;
    private Accessor elementAccessor;
    private int arrayLimit = -1;
    private YasTypeDescriptor yasTypeDescriptor;
    private boolean isFreed = false;

    public YasTypeDescriptor getYasTypeDescriptor() {
        return this.yasTypeDescriptor;
    }

    public YasArray(Session session) {
        this.session = session;
    }

    public boolean isFreed() {
        return this.isFreed;
    }

    private void a() throws YasException {
        if (this.isFreed) {
            throw SQLError.createSQLException("Operations on a freed array", YasState.NO_DATA);
        }
    }

    public int getArrayLimit() throws YasException {
        this.a();
        return this.arrayLimit;
    }

    public void setYasTypeDescriptor(YasTypeDescriptor yasTypeDescriptor) {
        this.yasTypeDescriptor = yasTypeDescriptor;
        this.setElementTypeCode(yasTypeDescriptor.getElementType());
        if (DataType.isUdtType(this.yasTypeDescriptor.getElementType())) {
            this.setElementTypeName(yasTypeDescriptor.getElementDescriptor().getFullTypeName());
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.a();
        return this.elementTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        this.a();
        return YasTypes.getSQLType(this.elementTypeCode);
    }

    @Override
    public Object getArray() throws SQLException {
        this.a();
        return this.elements;
    }

    public Object getArray(Map map) throws SQLException {
        Object object;
        this.a();
        if (this.elementTypeCode != 36 || this.elements.length == 0 || this.elements[0].getClass() == YasArray.getTypeClass(this.elementTypeName, map)) {
            return this.getArray();
        }
        if (this.elementAccessor == null) {
            object = (UdtAccessor)AccessorFactory.generateAccessorByDataType(this.elementTypeCode, this.session);
            ((UdtAccessor)object).setYasTypeDescriptor(this.elementDescriptor);
            object.setTypeMap(map);
            this.elementAccessor = object;
        }
        object = new Object[this.elements.length];
        for (int i = 0; i < ((Object[])object).length; ++i) {
            object[i] = this.elementAccessor.getValue(this.originalData, this.elementDateIndex[i], this.elementDateSize[i]);
        }
        return object;
    }

    private void a(long l, int n) throws SQLException {
        if (l <= 0L || n < 0) {
            throw SQLError.createSQLException("Invalid arguments, 'index' should be >= 1 and 'count' >= 0", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        this.a();
        this.a(l, n);
        int n2 = Math.min(this.elements.length, (int)(l - 1L));
        int n3 = Math.min(this.elements.length, n2 + n);
        return Arrays.copyOfRange(this.elements, n2, n3);
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        this.a();
        this.a(l, n);
        int n2 = Math.min(this.elements.length, (int)(l - 1L));
        int n3 = Math.min(this.elements.length, n2 + n);
        return Arrays.copyOfRange((Object[])this.getArray(map), n2, n3);
    }

    private Field[] b() {
        String string = DataType.isUdtType(this.elementTypeCode) ? null : this.elementTypeName;
        int n = this.elementTypeCode;
        Field[] fieldArray = new Field[]{new Field(0, YasType.INTEGER.getName(), YasType.INTEGER.getVendorTypeNumber(), 1, 0, -1, -128), new Field(1, string, n, 2, 0, -1, -128)};
        if (DataType.isUdtType(this.elementTypeCode)) {
            String[] stringArray = this.elementTypeName.split("\\.");
            fieldArray[1].setUdtTypeOwner(stringArray[0]);
            fieldArray[1].setUdtTypeName(stringArray[1]);
        }
        return fieldArray;
    }

    private RowData a(int n, int n2) throws SQLException {
        int n3 = Math.min(this.elements.length, n + n2);
        RowDataImpl rowDataImpl = new RowDataImpl(this.session, n3 - n);
        for (int i = n; i < n3; ++i) {
            byte[][] byArrayArray = new byte[2][];
            byArrayArray[0] = new byte[4];
            ByteConverter.int4(byArrayArray[0], 0, i + 1);
            byArrayArray[1] = Arrays.copyOfRange(this.originalData, this.elementDateIndex[i], this.elementDateIndex[i] + this.elementDateSize[i]);
            rowDataImpl.addRow(new Row(byArrayArray));
        }
        return rowDataImpl;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.a();
        return new YasArrayDataResultSet(this.session, this.b(), this.a(0, this.elements.length), null, this);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        this.a();
        return new YasArrayDataResultSet(this.session, this.b(), this.a(0, this.elements.length), map, this);
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        this.a();
        this.a(l, n);
        int n2 = Math.min(this.elements.length, (int)(l - 1L));
        return new YasArrayDataResultSet(this.session, this.b(), this.a(n2, n), null, this);
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        this.a();
        this.a(l, n);
        int n2 = Math.min(this.elements.length, (int)(l - 1L));
        return new YasArrayDataResultSet(this.session, this.b(), this.a(n2, n), map, this);
    }

    @Override
    public void free() throws SQLException {
        this.isFreed = true;
        this.elements = null;
    }

    public void setElementTypeCode(int n) {
        this.elementTypeCode = n;
        this.elementTypeName = DataType.getTypeName(n);
    }

    public void setElements(Object[] objectArray) {
        this.elements = objectArray;
    }

    public void setElementTypeName(String string) {
        this.elementTypeName = string;
    }

    @Override
    protected void doSerialize() throws SQLException {
        YasUdtSerializer yasUdtSerializer = new YasUdtSerializer();
        yasUdtSerializer.setSession(this.yasTypeDescriptor.getSession());
        yasUdtSerializer.serialize(this);
        this.serialData = yasUdtSerializer.getEncodedData();
        this.dataLen = yasUdtSerializer.getDataLen();
    }

    public static Object[] createElementArray(int n, int n2) {
        switch (n2) {
            case 2: {
                return new Byte[n];
            }
            case 3: {
                return new Short[n];
            }
            case 4: {
                return new Integer[n];
            }
            case 5: {
                return new Long[n];
            }
            case 10: {
                return new Float[n];
            }
            case 11: {
                return new Double[n];
            }
            case 12: {
                return new BigDecimal[n];
            }
            case 15: {
                return new Time[n];
            }
            case 13: {
                return new Date[n];
            }
            case 16: 
            case 17: 
            case 18: {
                return new Timestamp[n];
            }
            case 24: 
            case 26: {
                return new String[n];
            }
            case 28: {
                return new byte[n][];
            }
            case 29: {
                return new Clob[n];
            }
            case 30: {
                return new Blob[n];
            }
            case 31: {
                return new byte[n][];
            }
            case 1: {
                return new Boolean[n];
            }
            case 32: {
                return new YasRowID[n];
            }
            case 19: {
                return new Period[n];
            }
            case 20: {
                return new Duration[n];
            }
            case 34: {
                return new Object[n];
            }
            case 36: {
                return new YasStruct[n];
            }
            case 37: 
            case 38: {
                return new YasArray[n];
            }
        }
        return new Object[n];
    }

    public static YasArray decode(byte[] byArray, int n, Session session, YasTypeDescriptor yasTypeDescriptor) throws SQLException {
        int n2 = ++n;
        ++n;
        byte by = byArray[n2];
        if (by == 1) {
            return YasArray.decodeDfs(YasArray.decodeAsLob(byArray, n, session), 0, session, yasTypeDescriptor);
        }
        return YasArray.decodeDfs(byArray, n, session, yasTypeDescriptor);
    }

    public static YasArray decodeDfs(byte[] byArray, int n, Session session, YasTypeDescriptor yasTypeDescriptor) throws SQLException {
        int n2 = ByteConverter.int4(byArray, n += 2);
        int n3 = ByteConverter.int4(byArray, n += 4);
        long l = ByteConverter.int8(byArray, n += 4);
        n += 8;
        YasTypeDescriptor yasTypeDescriptor2 = yasTypeDescriptor.checkToidVersion(l, n3);
        YasArray yasArray = new YasArray(session);
        yasArray.setToid(l);
        yasArray.setYasTypeDescriptor(yasTypeDescriptor2);
        yasArray.setOriginalData(byArray);
        if (DataType.isUdtType(yasTypeDescriptor2.getElementType())) {
            yasArray.setElementDescriptor(yasTypeDescriptor2.getElementDescriptor());
        }
        Object[] objectArray = YasArray.createElementArray(n2, yasTypeDescriptor2.getElementType());
        yasArray.setElements(objectArray);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        yasArray.setElementDateIndexAndSize(nArray, nArray2);
        for (int i = 0; i < n2; ++i) {
            int n4 = yasTypeDescriptor2.getElementType();
            int[] nArray3 = YasArray.getDataLen(byArray, n, n4);
            int n5 = nArray3[0];
            nArray[i] = n = nArray3[1];
            nArray2[i] = n5;
            objectArray[i] = n5 == 0 ? null : AbstractUDT.decode(byArray, n, n5, session, yasTypeDescriptor2.getAttrDescriptor(i), n4, null);
            n += n5;
        }
        return yasArray;
    }
}

