/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.udt;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.BitAccessor;
import com.yashandb.protocol.accessor.RawAccessor;
import com.yashandb.protocol.accessor.UdtArrayAccessor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;

public class YasSQLInput
implements SQLInput {
    private int attrIndex = 0;
    private List accessors;
    private List udtDataList = new LinkedList();
    private YasConnection connection;

    public void addAttrData(byte[] byArray) {
        this.udtDataList.add(byArray);
    }

    public void setAccessors(List list) {
        this.accessors = list;
    }

    public void setConnection(YasConnection yasConnection) {
        this.connection = yasConnection;
    }

    @Override
    public String readString() throws SQLException {
        String string;
        try {
            string = ((Accessor)this.accessors.get(this.attrIndex)).getString((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return string;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        boolean bl;
        try {
            bl = ((Accessor)this.accessors.get(this.attrIndex)).getBoolean((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return bl;
    }

    @Override
    public byte readByte() throws SQLException {
        byte by;
        try {
            by = ((Accessor)this.accessors.get(this.attrIndex)).getByte((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return by;
    }

    @Override
    public short readShort() throws SQLException {
        short s;
        try {
            s = ((Accessor)this.accessors.get(this.attrIndex)).getShort((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return s;
    }

    @Override
    public int readInt() throws SQLException {
        int n;
        try {
            n = ((Accessor)this.accessors.get(this.attrIndex)).getInt((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return n;
    }

    @Override
    public long readLong() throws SQLException {
        long l;
        try {
            l = ((Accessor)this.accessors.get(this.attrIndex)).getLong((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return l;
    }

    @Override
    public float readFloat() throws SQLException {
        float f;
        try {
            f = ((Accessor)this.accessors.get(this.attrIndex)).getFloat((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return f;
    }

    @Override
    public double readDouble() throws SQLException {
        double d;
        try {
            d = ((Accessor)this.accessors.get(this.attrIndex)).getDouble((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return d;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = ((Accessor)this.accessors.get(this.attrIndex)).getBigDecimal((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return bigDecimal;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        byte[] byArray = null;
        try {
            if (this.udtDataList.get(this.attrIndex) != null) {
                if (!(this.accessors.get(this.attrIndex) instanceof RawAccessor) && !(this.accessors.get(this.attrIndex) instanceof BitAccessor)) {
                    throw SQLError.createSQLException("Invalid column type.", YasState.DATATYPE_MISMATCH);
                }
                byArray = ((Accessor)this.accessors.get(this.attrIndex)).getBytes((byte[])this.udtDataList.get(this.attrIndex));
            }
        }
        finally {
            ++this.attrIndex;
        }
        return byArray;
    }

    @Override
    public Date readDate() throws SQLException {
        Date date;
        try {
            date = ((Accessor)this.accessors.get(this.attrIndex)).getDate((byte[])this.udtDataList.get(this.attrIndex), null);
        }
        finally {
            ++this.attrIndex;
        }
        return date;
    }

    @Override
    public Time readTime() throws SQLException {
        Time time;
        try {
            time = ((Accessor)this.accessors.get(this.attrIndex)).getTime((byte[])this.udtDataList.get(this.attrIndex), null);
        }
        finally {
            ++this.attrIndex;
        }
        return time;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        Timestamp timestamp;
        try {
            timestamp = ((Accessor)this.accessors.get(this.attrIndex)).getTimestamp((byte[])this.udtDataList.get(this.attrIndex), null);
        }
        finally {
            ++this.attrIndex;
        }
        return timestamp;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Reader reader;
        try {
            reader = ((Accessor)this.accessors.get(this.attrIndex)).getCharacterStream((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return reader;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        InputStream inputStream;
        try {
            inputStream = ((Accessor)this.accessors.get(this.attrIndex)).getBinaryStream((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return inputStream;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        InputStream inputStream;
        try {
            inputStream = ((Accessor)this.accessors.get(this.attrIndex)).getBinaryStream((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return inputStream;
    }

    @Override
    public Object readObject() throws SQLException {
        byte[] byArray = (byte[])this.udtDataList.get(this.attrIndex);
        if (byArray == null || byArray.length == 0) {
            ++this.attrIndex;
            return null;
        }
        return ((Accessor)this.accessors.get(this.attrIndex++)).getValue(byArray, 0, byArray.length);
    }

    public Object readObject(Class clazz) throws SQLException {
        try {
            Object object = ((Accessor)this.accessors.get(this.attrIndex)).getObject((byte[])this.udtDataList.get(this.attrIndex), clazz, this.connection);
            return object;
        }
        finally {
            ++this.attrIndex;
        }
    }

    @Override
    public Ref readRef() throws SQLException {
        return null;
    }

    @Override
    public Blob readBlob() throws SQLException {
        try {
            YasBlob yasBlob = ((Accessor)this.accessors.get(this.attrIndex)).getBlob((byte[])this.udtDataList.get(this.attrIndex), this.connection.getSession());
            return yasBlob;
        }
        finally {
            ++this.attrIndex;
        }
    }

    @Override
    public Clob readClob() throws SQLException {
        try {
            YasClob yasClob = ((Accessor)this.accessors.get(this.attrIndex)).getClob((byte[])this.udtDataList.get(this.attrIndex), this.connection.getSession());
            return yasClob;
        }
        finally {
            ++this.attrIndex;
        }
    }

    @Override
    public Array readArray() throws SQLException {
        if (this.accessors.get(this.attrIndex) instanceof UdtArrayAccessor) {
            return (Array)((Accessor)this.accessors.get(this.attrIndex)).getValue((byte[])this.udtDataList.get(this.attrIndex++), 0, 0);
        }
        throw SQLError.createSQLException("Invalid column type.", YasState.DATA_TYPE_MISMATCH);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.attrIndex == 0) {
            throw SQLError.createSQLException("Unread data.", YasState.NO_DATA);
        }
        return this.udtDataList.get(this.attrIndex - 1) == null || ((byte[])this.udtDataList.get(this.attrIndex - 1)).length == 0;
    }

    @Override
    public URL readURL() throws SQLException {
        return null;
    }

    @Override
    public NClob readNClob() throws SQLException {
        return null;
    }

    @Override
    public String readNString() throws SQLException {
        try {
            String string = ((Accessor)this.accessors.get(this.attrIndex)).getString((byte[])this.udtDataList.get(this.attrIndex));
            return string;
        }
        finally {
            ++this.attrIndex;
        }
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return null;
    }

    @Override
    public RowId readRowId() throws SQLException {
        RowId rowId;
        try {
            rowId = ((Accessor)this.accessors.get(this.attrIndex)).getRowId((byte[])this.udtDataList.get(this.attrIndex));
        }
        finally {
            ++this.attrIndex;
        }
        return rowId;
    }
}

