/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.udt;

import com.yashandb.Session;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.udt.AbstractUDT;
import com.yashandb.udt.YasSQLInput;
import com.yashandb.udt.YasSQLOutput;
import com.yashandb.udt.YasTypeDescriptor;
import com.yashandb.udt.YasUdtSerializer;
import com.yashandb.util.ByteConverter;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;

public class YasStruct
extends AbstractUDT
implements Struct {
    private Object[] attributes;
    private String fullTypeName;
    private YasTypeDescriptor typeDescriptor;

    public YasTypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public YasStruct(String string) {
        this.fullTypeName = string;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.fullTypeName;
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes;
    }

    public Object[] getAttributes(Map map) throws SQLException {
        if (this.typeDescriptor.getUdtAttrsDescriptors() == null || this.typeDescriptor.getUdtAttrsDescriptors().size() == 0) {
            return this.attributes;
        }
        int n = this.typeDescriptor.getAttrTypes().size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = AbstractUDT.decode(this.originalData, this.elementDateIndex[i], this.elementDateSize[i], this.session, this.typeDescriptor.getAttrDescriptor(i), (Integer)this.typeDescriptor.getAttrTypes().get(i), map);
        }
        return objectArray;
    }

    public void setTypeDescriptor(YasTypeDescriptor yasTypeDescriptor) {
        this.typeDescriptor = yasTypeDescriptor;
    }

    public void setAttributes(Object[] objectArray) {
        this.attributes = objectArray;
    }

    @Override
    protected void doSerialize() throws SQLException {
        YasUdtSerializer yasUdtSerializer = new YasUdtSerializer();
        yasUdtSerializer.setSession(this.typeDescriptor.getSession());
        yasUdtSerializer.serialize(this);
        this.serialData = yasUdtSerializer.getEncodedData();
        this.dataLen = yasUdtSerializer.getDataLen();
        this.asLob = yasUdtSerializer.isAsLob();
    }

    public static YasStruct toYasStruct(SQLData sQLData, YasConnection yasConnection) throws SQLException {
        YasTypeDescriptor yasTypeDescriptor = YasTypeDescriptor.getInstance(yasConnection.getSession(), sQLData.getSQLTypeName());
        YasSQLOutput yasSQLOutput = new YasSQLOutput(yasTypeDescriptor);
        sQLData.writeSQL(yasSQLOutput);
        return yasSQLOutput.getYasStruct();
    }

    public static Object decode(byte[] byArray, int n, Session session, YasTypeDescriptor yasTypeDescriptor, Map map) throws SQLException {
        int n2 = ++n;
        ++n;
        byte by = byArray[n2];
        if (by == 1) {
            return YasStruct.decodeDfs(YasStruct.decodeAsLob(byArray, n, session), 0, session, yasTypeDescriptor, map);
        }
        return YasStruct.decodeDfs(byArray, n, session, yasTypeDescriptor, map);
    }

    public static Object decodeDfs(byte[] byArray, int n, Session session, YasTypeDescriptor yasTypeDescriptor, Map map) throws SQLException {
        Object t;
        int n2 = ByteConverter.int4(byArray, n += 2);
        int n3 = ByteConverter.int4(byArray, n += 4);
        long l = ByteConverter.int8(byArray, n += 4);
        n += 8;
        YasTypeDescriptor yasTypeDescriptor2 = yasTypeDescriptor.checkToidVersion(l, n3);
        String string = yasTypeDescriptor2.getFullTypeName();
        Class clazz = YasStruct.getTypeClass(string, map);
        if (clazz == null) {
            YasStruct yasStruct = new YasStruct(string);
            yasStruct.setOriginalData(byArray);
            yasStruct.setSession(session);
            yasStruct.setToid(l);
            yasStruct.setTypeDescriptor(yasTypeDescriptor2);
            Object[] objectArray = new Object[n2];
            yasStruct.setAttributes(objectArray);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            yasStruct.setElementDateIndexAndSize(nArray, nArray2);
            for (int i = 0; i < n2; ++i) {
                int n4 = (Integer)yasTypeDescriptor2.getAttrTypes().get(i);
                int[] nArray3 = YasStruct.getDataLen(byArray, n, n4);
                int n5 = nArray3[0];
                nArray[i] = n = nArray3[1];
                nArray2[i] = n5;
                objectArray[i] = n5 == 0 ? null : AbstractUDT.decode(byArray, n, n5, session, yasTypeDescriptor2.getAttrDescriptor(i), n4, null);
                n += n5;
            }
            return yasStruct;
        }
        try {
            t = clazz.newInstance();
            if (!(t instanceof SQLData)) {
                throw SQLError.createSQLException("map to java class failed, the mapped class has not implement SQLData", YasState.DATA_ERROR);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw SQLError.createSQLException("map to java class failed: " + reflectiveOperationException.getMessage(), YasState.DATA_ERROR);
        }
        YasSQLInput yasSQLInput = new YasSQLInput();
        yasSQLInput.setConnection(session.getConnection());
        yasSQLInput.setAccessors(yasTypeDescriptor2.getAttrAccessors(map));
        for (int i = 0; i < n2; ++i) {
            int n6 = (Integer)yasTypeDescriptor2.getAttrTypes().get(i);
            int[] nArray = YasStruct.getDataLen(byArray, n, n6);
            int n7 = nArray[0];
            n = nArray[1];
            byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + n7);
            yasSQLInput.addAttrData(byArray2);
            n += n7;
        }
        ((SQLData)t).readSQL(yasSQLInput, string);
        return t;
    }
}

