/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.udt;

import com.yashandb.Session;
import com.yashandb.core.DataType;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.protocol.accessor.UdtAccessor;
import com.yashandb.util.ByteConverter;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class YasTypeDescriptor {
    private Session session;
    private String fullTypeName;
    private long toid;
    private int version;
    private int attrsCount;
    private ArrayList attrTypes;
    private int elementType = 0;
    private int startIndex = 0;
    LinkedList udtDescriptors;

    public YasTypeDescriptor(Session session) {
        this.session = session;
    }

    public YasTypeDescriptor(Session session, String string) throws SQLException {
        this.session = session;
        this.fullTypeName = string;
        this.getMetaData();
        if (string != null) {
            session.setTypeShapeCache(string, this);
        }
    }

    public static YasTypeDescriptor getInstance(Session session, String string) throws SQLException {
        YasTypeDescriptor yasTypeDescriptor = session.getTypeShapeCache(string);
        if (yasTypeDescriptor != null) {
            return yasTypeDescriptor;
        }
        return new YasTypeDescriptor(session, string);
    }

    public Session getSession() {
        return this.session;
    }

    void a(String string) {
        this.fullTypeName = string;
        this.session.setTypeShapeCache(string, this);
    }

    void a(long l) {
        this.toid = l;
    }

    public long getToid() {
        return this.toid;
    }

    int a(byte[] byArray, int n) {
        int n2 = n;
        if (this.udtDescriptors == null) {
            this.udtDescriptors = new LinkedList();
        }
        YasTypeDescriptor yasTypeDescriptor = new YasTypeDescriptor(this.session);
        yasTypeDescriptor.startIndex = (int)ByteConverter.int8(byArray, n);
        this.udtDescriptors.add(yasTypeDescriptor);
        return (n += 8) - n2;
    }

    int b(byte[] byArray, int n) {
        int n2 = n;
        for (int i = 0; i < this.attrsCount; ++i) {
            byte by = byArray[n];
            n += 8;
            if (DataType.isUdtType(by)) {
                n += this.a(byArray, n);
            }
            if (this.attrTypes == null) {
                this.attrTypes = new ArrayList();
            }
            this.attrTypes.add(Integer.valueOf(by));
        }
        return n - n2;
    }

    int c(byte[] byArray, int n) {
        int n2 = n;
        this.elementType = byArray[n += 2];
        n += 8;
        if (DataType.isUdtType(this.elementType)) {
            n += this.a(byArray, n);
        }
        return n - n2;
    }

    int d(byte[] byArray, int n) {
        int n2 = n;
        if (n == 0) {
            n += 8;
            ++n;
        }
        this.attrsCount = ByteConverter.int2(byArray, n);
        n += 2;
        n = this.attrsCount == 0 ? (n += this.c(byArray, n)) : (n += this.b(byArray, n));
        if (this.udtDescriptors != null) {
            for (YasTypeDescriptor yasTypeDescriptor : this.udtDescriptors) {
                int n3 = yasTypeDescriptor.d(byArray, yasTypeDescriptor.startIndex);
                if (n != yasTypeDescriptor.startIndex) continue;
                n += n3;
            }
        }
        return ++n - n2;
    }

    public List getAttrTypes() {
        return this.attrTypes;
    }

    public String getFullTypeName() {
        return this.fullTypeName;
    }

    public int getElementType() {
        return this.elementType;
    }

    public YasTypeDescriptor getElementDescriptor() {
        return (YasTypeDescriptor)this.udtDescriptors.get(0);
    }

    public List getUdtAttrsDescriptors() {
        return this.udtDescriptors;
    }

    private void a(YasTypeDescriptor yasTypeDescriptor) throws SQLException {
        String string = "SELECT SC.ELEM_TOID, SU.NAME, SO.NAME FROM SYS.TOID$ ST LEFT JOIN SYS.OBJ$ SO ON SO.OBJ# = ST.OBJ# LEFT JOIN SYS.USER$ SU ON SU.USER# = SO.OWNER# LEFT JOIN SYS.COLLECTION$ SC ON SC.ELEM_TOID = ST.TOID WHERE SC.TOID = ?";
        PreparedStatement preparedStatement = this.session.getConnection().prepareStatement(string);
        preparedStatement.setLong(1, this.toid);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        resultSet.next();
        long l = resultSet.getLong(1);
        String string2 = resultSet.getString(2).toUpperCase();
        String string3 = resultSet.getString(3).toUpperCase();
        resultSet.close();
        preparedStatement.close();
        yasTypeDescriptor.a(string2 + "." + string3);
        yasTypeDescriptor.a(l);
        yasTypeDescriptor.fillTypeName();
    }

    private void a() throws SQLException {
        if (((YasTypeDescriptor)this.udtDescriptors.get(0)).getFullTypeName() == null) {
            String string = "SELECT SA.ATTR_TOID, SU.NAME, SO.NAME FROM SYS.ATTRIBUTE$ SA LEFT JOIN SYS.TOID$ ST ON ST.TOID = SA.ATTR_TOID LEFT JOIN SYS.OBJ$ SO ON SO.OBJ# = ST.OBJ# LEFT JOIN SYS.USER$ SU ON SU.USER# = SO.OWNER#  WHERE SA.TOID = ? ORDER BY SA.ATTRIBUTE#";
            Object object = this.session.getConnection().prepareCall(string);
            object.setLong(1, this.toid);
            object.execute();
            ResultSet resultSet = object.getResultSet();
            int n = 0;
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                if (string2 == null) continue;
                YasTypeDescriptor yasTypeDescriptor = (YasTypeDescriptor)this.udtDescriptors.get(n++);
                yasTypeDescriptor.a(l);
                yasTypeDescriptor.a(string2.toUpperCase() + "." + string3.toUpperCase());
            }
            resultSet.close();
            object.close();
        }
        for (Object object : this.udtDescriptors) {
            ((YasTypeDescriptor)object).fillTypeName();
        }
    }

    public void fillTypeName() throws SQLException {
        if (this.udtDescriptors == null || this.udtDescriptors.isEmpty()) {
            return;
        }
        if (this.attrsCount == 0) {
            this.a((YasTypeDescriptor)this.udtDescriptors.get(0));
            return;
        }
        this.a();
    }

    public void getMetaData() throws SQLException {
        Object object;
        String string = "begin :1 := sys.dbms_pickler.get_type_shape(:2, :3, :4, :5, :6, :7, :8, :9, :10); end;";
        CallableStatement callableStatement = this.session.getConnection().prepareCall(string);
        callableStatement.setString(2, this.fullTypeName);
        callableStatement.registerOutParameter(1, 4);
        callableStatement.registerOutParameter(2, 12);
        callableStatement.registerOutParameter(3, -5);
        callableStatement.registerOutParameter(4, 4);
        callableStatement.registerOutParameter(5, -2);
        callableStatement.registerOutParameter(6, 12);
        callableStatement.registerOutParameter(7, 12);
        callableStatement.registerOutParameter(8, 12);
        callableStatement.registerOutParameter(9, 2012);
        callableStatement.registerOutParameter(10, 2012);
        callableStatement.execute();
        this.toid = callableStatement.getLong(3);
        this.version = callableStatement.getInt(4);
        byte[] byArray = callableStatement.getBytes(5);
        if (byArray == null) {
            throw SQLError.createSQLException("invalid type: " + this.fullTypeName, YasState.DATA_ERROR);
        }
        this.d(byArray, 0);
        ResultSet resultSet = (ResultSet)callableStatement.getObject(9);
        int n = 0;
        while (resultSet.next()) {
            object = resultSet.getString(4);
            String string2 = resultSet.getString(5);
            long l = resultSet.getLong(6);
            if (string2 == null) continue;
            String string3 = string2.toUpperCase() + "." + ((String)object).toUpperCase();
            YasTypeDescriptor yasTypeDescriptor = (YasTypeDescriptor)this.udtDescriptors.get(n++);
            yasTypeDescriptor.a(string3);
            yasTypeDescriptor.a(l);
        }
        resultSet.close();
        object = (ResultSet)callableStatement.getObject(10);
        object.close();
        callableStatement.close();
        this.fillTypeName();
    }

    public YasTypeDescriptor getAttrDescriptor(int n) {
        if (this.attrTypes == null) {
            if (DataType.isUdtType(this.elementType)) {
                return (YasTypeDescriptor)this.udtDescriptors.get(0);
            }
            return null;
        }
        if (this.udtDescriptors == null || this.udtDescriptors.isEmpty() || !DataType.isUdtType((Integer)this.attrTypes.get(n))) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!DataType.isUdtType((Integer)this.attrTypes.get(i))) continue;
            ++n2;
        }
        return (YasTypeDescriptor)this.udtDescriptors.get(n2);
    }

    public List getAttrAccessors(Map map) throws SQLException {
        LinkedList<Accessor> linkedList = new LinkedList<Accessor>();
        int n = 0;
        for (Integer n2 : this.attrTypes) {
            Accessor accessor = AccessorFactory.generateAccessorByDataType(n2, this.session);
            linkedList.add(accessor);
            if (!(accessor instanceof UdtAccessor)) continue;
            ((UdtAccessor)accessor).setYasTypeDescriptor((YasTypeDescriptor)this.getUdtAttrsDescriptors().get(n++));
            accessor.setTypeMap(map);
        }
        return linkedList;
    }

    public YasTypeDescriptor checkToidVersion(long l, int n) throws SQLException {
        if (this.toid != l || this.version != 0 && this.version != n) {
            return new YasTypeDescriptor(this.session, this.fullTypeName);
        }
        return this;
    }
}

