/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.udt;

import com.yashandb.Session;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasRowID;
import com.yashandb.jdbc.YasSQLXML;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.json.YasonFactory;
import com.yashandb.json.YasonValue;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.TypeConverter;
import com.yashandb.udt.AbstractUDT;
import com.yashandb.udt.YasArray;
import com.yashandb.udt.YasStruct;
import com.yashandb.udt.YasTypeDescriptor;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.Messages;
import com.yashandb.util.YasTime;
import com.yashandb.util.YasTimestamp;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class YasUdtSerializer {
    private static final byte UDT_ARRAY_TYPE_FLAG = 16;
    private int offset = 0;
    private byte[] encodedData = null;
    private Blob blob = null;
    private static final short CHARSET = 0;
    private int realDataLen = 0;
    private boolean asLob = false;
    private Session session;
    private YasonFactory yasonFactory;

    public boolean isAsLob() {
        return this.asLob;
    }

    public Blob getBlob() {
        return this.blob;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    private byte[] a(int n) {
        byte[] byArray;
        if (n <= 253) {
            byArray = new byte[]{(byte)(n & 0xFF)};
        } else {
            byArray = new byte[3];
            byArray[0] = -3;
            ByteConverter.int2(byArray, 1, n);
        }
        return byArray;
    }

    private byte[] b(int n) {
        byte[] byArray;
        if (n <= 250) {
            byArray = new byte[]{(byte)(n & 0xFF)};
        } else if (n < Short.MAX_VALUE) {
            byArray = new byte[3];
            byArray[0] = -5;
            ByteConverter.int2(byArray, 1, n);
        } else {
            byArray = new byte[5];
            byArray[0] = -4;
            ByteConverter.int4(byArray, 1, n);
        }
        return byArray;
    }

    private byte[] a() {
        byte[] byArray = new byte[]{-1};
        return byArray;
    }

    private byte[] a(InputStream inputStream) throws YasException {
        try {
            int n;
            byte[] byArray = new byte[2048];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = inputStream.read(byArray)) > 0) {
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((char)(byArray[i] & 0xFF));
                }
            }
            return this.a(stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(iOException.getMessage(), YasState.IO_ERROR);
        }
    }

    private byte[] a(String string) {
        byte[] byArray = string.getBytes(CharacterSet.getCharSet((short)0));
        byte[] byArray2 = this.a(byArray.length);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private byte[] a(BigDecimal bigDecimal) throws SQLException {
        byte[] byArray = new byte[18];
        int n = ByteConverter.bigDecimalToBytes(byArray, 0, bigDecimal);
        byte[] byArray2 = this.a(n);
        byte[] byArray3 = new byte[n + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, n);
        return byArray3;
    }

    private byte[] a(byte by) {
        byte[] byArray = this.a(1);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = by;
        return byArray2;
    }

    private byte[] a(boolean bl) {
        if (bl) {
            return this.a((byte)1);
        }
        return this.a((byte)0);
    }

    private byte[] a(short s) {
        byte[] byArray = this.a(2);
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int2(byArray2, byArray.length, s);
        return byArray2;
    }

    private byte[] c(int n) {
        byte[] byArray = this.a(4);
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int4(byArray2, byArray.length, n);
        return byArray2;
    }

    private byte[] a(Object object) throws YasException {
        Period period;
        if (object instanceof String) {
            period = Period.parse(object.toString());
        } else if (object instanceof Period) {
            period = (Period)object;
        } else {
            throw SQLError.transformException(object.getClass().getName(), "TIMESTAMP_WITH_TIMEZONE");
        }
        byte[] byArray = this.a(4);
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int4(byArray2, byArray.length, (int)period.toTotalMonths());
        return byArray2;
    }

    private byte[] b(Object object) throws YasException {
        Duration duration;
        if (object instanceof String) {
            duration = Duration.parse(object.toString());
        } else if (object instanceof Duration) {
            duration = (Duration)object;
        } else {
            throw SQLError.transformException(object.getClass().getName(), "DsInterval");
        }
        byte[] byArray = this.a(8);
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int8(byArray2, byArray.length, duration.toNanos() / 1000L);
        return byArray2;
    }

    private byte[] a(long l) {
        byte[] byArray = this.a(8);
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int8(byArray2, byArray.length, l);
        return byArray2;
    }

    private byte[] a(float f) {
        byte[] byArray = this.a(4);
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.float4(byArray2, byArray.length, f);
        return byArray2;
    }

    private byte[] a(double d) {
        byte[] byArray = this.a(8);
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.float8(byArray2, byArray.length, d);
        return byArray2;
    }

    private byte[] c(Object object) throws YasException {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return this.a(byArray, 0, byArray.length);
        }
        throw SQLError.transformException(object.getClass().getName(), "bytes");
    }

    private byte[] a(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.a(n2);
        byte[] byArray3 = new byte[byArray2.length + n2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, n, byArray3, byArray2.length, n2);
        return byArray3;
    }

    private byte[] a(Timestamp timestamp) {
        long l = timestamp.getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setDateAndTime(l);
        internalTimeStamp.setFraction(timestamp.getNanos() / 1000);
        long l2 = InternalTimeStamp.transTimeStampToValue(internalTimeStamp);
        byte[] byArray = this.a(8);
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int8(byArray2, byArray.length, l2);
        return byArray2;
    }

    private byte[] d(Object object) throws YasException {
        if (object instanceof OffsetDateTime) {
            return this.a(Timestamp.valueOf(((OffsetDateTime)object).toLocalDateTime()));
        }
        if (object instanceof YasTimestamp) {
            return this.a((YasTimestamp)object);
        }
        throw SQLError.transformException(object.getClass().getName(), "TIMESTAMP_WITH_TIMEZONE");
    }

    private byte[] a(Time time) {
        long l = time.getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setTime(l);
        if (time instanceof YasTime) {
            internalTimeStamp.setFraction(((YasTime)time).getNanos() / 1000);
        }
        long l2 = InternalTimeStamp.transTimeToValue(internalTimeStamp);
        byte[] byArray = this.a(8);
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int8(byArray2, byArray.length, l2);
        return byArray2;
    }

    private byte[] e(Object object) throws YasException {
        if (object instanceof OffsetDateTime) {
            return this.a(Time.valueOf(((OffsetDateTime)object).toLocalDateTime().toLocalTime()));
        }
        if (object instanceof OffsetTime) {
            return this.a(Time.valueOf(((OffsetTime)object).toLocalTime()));
        }
        throw SQLError.transformException(object.getClass().getName(), "TIME_WITH_TIMEZONE");
    }

    private byte[] a(Date date) {
        long l = date.getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setDateAndTime(l);
        long l2 = InternalTimeStamp.transTimeStampToValue(internalTimeStamp);
        byte[] byArray = this.a(8);
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        ByteConverter.int8(byArray2, byArray.length, l2);
        return byArray2;
    }

    private byte[] a(RowId rowId) throws SQLException {
        if (!(rowId instanceof YasRowID)) {
            throw SQLError.createSQLException("invalid rowid", YasState.DATA_ERROR);
        }
        YasRowID yasRowID = (YasRowID)rowId;
        byte[] byArray = yasRowID.getRowIdBytes();
        byte[] byArray2 = this.a(byArray.length);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private byte[] f(Object object) throws SQLException {
        Object object2;
        YasBlob yasBlob = this.session.createBlob();
        if (object instanceof YasonValue) {
            yasBlob.setBytes(1L, ((YasonValue)object).getBinaryData());
        } else if (object instanceof byte[]) {
            yasBlob.setBytes(1L, (byte[])object);
        } else if (object instanceof InputStream) {
            try {
                object2 = new byte[2048];
                int n = 0;
                while ((n = ((InputStream)object).read((byte[])object2)) > 0) {
                    yasBlob.setBytes(1L, Arrays.copyOfRange((byte[])object2, 0, n));
                }
            }
            catch (IOException iOException) {
                throw SQLError.createSQLException(iOException.getMessage(), YasState.IO_ERROR);
            }
        } else {
            if (this.yasonFactory == null) {
                this.yasonFactory = new YasonFactory();
            }
            object2 = this.yasonFactory.createJsonTextParser(new StringReader(TypeConverter.castToString(object, 3009)));
            object2.next();
            YasonValue yasonValue = object2.getValue();
            yasBlob.setBytes(1L, yasonValue.getBinaryData());
        }
        object2 = yasBlob.getLobLocator();
        byte[] byArray = this.a(((byte[])object2).length);
        byte[] byArray2 = new byte[byArray.length + ((byte[])object2).length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(object2, 0, byArray2, byArray.length, ((Object)object2).length);
        return byArray2;
    }

    private byte[] g(Object object) throws SQLException {
        byte[] byArray;
        Object object2;
        if (object instanceof SQLXML) {
            object2 = this.session.createClob();
            ((YasClob)object2).setString(1L, ((YasSQLXML)object).getString());
            byArray = ((YasClob)object2).getLobLocator();
        } else if (object instanceof Clob) {
            byArray = ((YasClob)object).getLobLocator();
        } else if (object instanceof String) {
            object2 = this.session.createClob();
            ((YasClob)object2).setString(1L, (String)object);
            byArray = ((YasClob)object2).getLobLocator();
        } else {
            throw SQLError.transformException(object.getClass().getName(), "SQLXML");
        }
        object2 = this.a(byArray.length);
        byte[] byArray2 = new byte[((Object)object2).length + byArray.length];
        System.arraycopy(object2, 0, byArray2, 0, ((Object)object2).length);
        System.arraycopy(byArray, 0, byArray2, ((Object)object2).length, byArray.length);
        return byArray2;
    }

    private byte[] a(YasBlob yasBlob) {
        byte[] byArray = yasBlob.getLobLocator();
        byte[] byArray2 = this.b(byArray.length);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private byte[] a(YasClob yasClob) {
        byte[] byArray = yasClob.getLobLocator();
        byte[] byArray2 = this.b(byArray.length);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private byte[] a(AbstractUDT abstractUDT) throws SQLException {
        byte[] byArray = abstractUDT.getSerialData();
        int n = byArray.length - 2;
        byte[] byArray2 = this.b(n);
        byte[] byArray3 = new byte[byArray2.length + n];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 2, byArray3, byArray2.length, n);
        return byArray3;
    }

    protected byte[] serializeObject(int n, Object object) throws SQLException {
        if (object == null) {
            return this.a();
        }
        int n2 = YasTypes.getSQLType(n);
        switch (n2) {
            case 7: {
                return this.a(TypeConverter.castToFloat(object, n2));
            }
            case -5: {
                return this.a(TypeConverter.castToLong(object, n2));
            }
            case 4: {
                return this.c(TypeConverter.castToInt(object, n2));
            }
            case -6: {
                return this.a((byte)TypeConverter.castToInt(object, n2));
            }
            case 5: {
                return this.a((short)TypeConverter.castToInt(object, n2));
            }
            case 2: 
            case 3: {
                return this.a(TypeConverter.castToBigDecimal(object, -1, n2));
            }
            case 6: 
            case 8: {
                return this.a(TypeConverter.castToDouble(object, n2));
            }
            case 16: {
                return this.a(TypeConverter.castToBoolean(object));
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: {
                return this.c(object);
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof InputStream) {
                    return this.a((InputStream)object);
                }
                return this.a(TypeConverter.castToString(object, n2));
            }
            case 3009: {
                return this.f(object);
            }
            case 91: {
                return this.a(TypeConverter.castToDate(object));
            }
            case 92: {
                return this.a(TypeConverter.castToTime(object));
            }
            case 2013: {
                return this.e(object);
            }
            case 93: {
                return this.a(TypeConverter.castToTimeStamp(object));
            }
            case 2014: {
                return this.d(object);
            }
            case 3002: {
                return this.b(object);
            }
            case 3001: {
                return this.a(object);
            }
            case -16: 
            case -15: 
            case -9: {
                return this.a((String)object);
            }
            case 2004: {
                return this.a((YasBlob)object);
            }
            case 2005: 
            case 2011: {
                return this.a((YasClob)object);
            }
            case 2002: {
                if (object instanceof SQLData) {
                    YasStruct yasStruct = YasStruct.toYasStruct((SQLData)object, this.session.getConnection());
                    return this.a((AbstractUDT)yasStruct);
                }
                return this.a((AbstractUDT)object);
            }
            case 2003: {
                return this.a((AbstractUDT)object);
            }
            case 2009: {
                return this.g(object);
            }
            case -8: {
                return this.a((RowId)object);
            }
        }
        throw SQLError.createSQLException(Messages.get("Unsupported SQL Types Code: {0}", n2), YasState.INVALID_PARAMETER_TYPE);
    }

    private void a(YasStruct yasStruct) throws SQLException {
        Object[] objectArray = yasStruct.getAttributes();
        YasTypeDescriptor yasTypeDescriptor = yasStruct.getTypeDescriptor();
        int n = 0;
        List list = yasTypeDescriptor.getAttrTypes();
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        for (int i = 0; i < objectArray.length; ++i) {
            byte[] byArray = this.serializeObject((Integer)list.get(i), objectArray[i]);
            n += byArray.length;
            linkedList.add(byArray);
        }
        this.a(n, linkedList, yasStruct.getToid());
    }

    private void a(YasArray yasArray) throws SQLException {
        Object[] objectArray = (Object[])yasArray.getArray();
        int n = yasArray.getYasTypeDescriptor().getElementType();
        int n2 = 0;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        for (Object object : objectArray) {
            byte[] byArray = this.serializeObject(n, object);
            n2 += byArray.length;
            linkedList.add(byArray);
        }
        this.a(n2, linkedList, yasArray.getToid());
        this.encodedData[2] = 16;
    }

    private void a(int n, List list, long l) {
        this.encodedData = new byte[n + 20];
        this.offset = 0;
        this.asLob = false;
        this.encodedData[this.offset++] = 1;
        this.encodedData[this.offset++] = 0;
        this.offset += 2;
        ByteConverter.int4(this.encodedData, this.offset, list.size());
        this.offset += 4;
        ByteConverter.int4(this.encodedData, this.offset, 1);
        this.offset += 4;
        ByteConverter.int8(this.encodedData, this.offset, l);
        this.offset += 8;
        list.forEach(byArray -> {
            System.arraycopy(byArray, 0, this.encodedData, this.offset, ((byte[])byArray).length);
            this.offset += ((byte[])byArray).length;
        });
        list.clear();
    }

    public void serialize(YasStruct yasStruct) throws SQLException {
        this.a(yasStruct);
        this.realDataLen = this.offset;
    }

    public void serialize(YasArray yasArray) throws SQLException {
        this.a(yasArray);
        this.realDataLen = this.offset;
    }

    public byte[] getEncodedData() {
        return Arrays.copyOfRange(this.encodedData, 0, this.offset);
    }

    public int getDataLen() {
        return this.realDataLen;
    }
}

