/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLException;

public class ByteConverter {
    private static final int SIGN_MASK = 1;
    private static final int EXP_SIGN_MASK = 2;
    private static final int SCALE_MIN = -131;
    private static final int SCALE_MAX = 124;

    private ByteConverter() {
    }

    public static long int8(byte[] byArray, int n) {
        return (long)(byArray[n] & 0xFF) + ((long)(byArray[n + 1] & 0xFF) << 8) + ((long)(byArray[n + 2] & 0xFF) << 16) + ((long)(byArray[n + 3] & 0xFF) << 24) + ((long)(byArray[n + 4] & 0xFF) << 32) + ((long)(byArray[n + 5] & 0xFF) << 40) + ((long)(byArray[n + 6] & 0xFF) << 48) + ((long)(byArray[n + 7] & 0xFF) << 56);
    }

    public static int int4(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    public static short int2(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8));
    }

    public static int uint2(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    public static float float4(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteConverter.int4(byArray, n));
    }

    public static double float8(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteConverter.int8(byArray, n));
    }

    public static BigDecimal toBigDecimal(byte[] byArray, int n) {
        int n2 = byArray.length - n;
        return ByteConverter.toBigDecimal(byArray, n, n2);
    }

    public static BigDecimal toBigDecimal(byte[] byArray, int n, int n2) {
        if (n2 <= 2) {
            if (n2 == 1) {
                int n3 = byArray[n] & 0xFF;
                return new BigDecimal(n3);
            }
            int n4 = ByteConverter.int2(byArray, n) & 0xFFFF;
            return new BigDecimal(n4);
        }
        int n5 = byArray[n] & 1;
        int n6 = byArray[n] & 2;
        int n7 = byArray[n + 1] & 0xFF;
        if (n6 == 2) {
            n7 = -n7;
        }
        int n8 = n5 == 1 ? -1 : 1;
        byte[] byArray2 = ByteConverter.a(byArray, n + 2, n + n2);
        BigInteger bigInteger = new BigInteger(n8, byArray2);
        return new BigDecimal(bigInteger, -n7);
    }

    public static long bitBytesToLong(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l |= (long)(byArray[i] & 0xFF) << 8 * i;
        }
        return l;
    }

    public static String bitBytesToString(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n3 = 0;
        for (int i = n + n2 - 1; i >= n; --i) {
            for (int j = 7; j >= 0; --j) {
                n3 = byArray[i] >> j & 1;
                if (n3 == 1) {
                    bl = true;
                    stringBuilder.append("1");
                    continue;
                }
                if (!bl) continue;
                stringBuilder.append("0");
            }
        }
        String string = stringBuilder.toString();
        if (string.isEmpty()) {
            return "0";
        }
        return string;
    }

    private static byte[] a(byte[] byArray, int n, int n2) {
        int n3 = 0;
        byte[] byArray2 = new byte[n2 - n];
        for (int i = n2 - 1; i >= n; --i) {
            byArray2[n3++] = byArray[i];
        }
        return byArray2;
    }

    public static void int8(byte[] byArray, int n, long l) {
        byArray[n] = (byte)l;
        byArray[n + 1] = (byte)(l >>> 8);
        byArray[n + 2] = (byte)(l >>> 16);
        byArray[n + 3] = (byte)(l >>> 24);
        byArray[n + 4] = (byte)(l >>> 32);
        byArray[n + 5] = (byte)(l >>> 40);
        byArray[n + 6] = (byte)(l >>> 48);
        byArray[n + 7] = (byte)(l >>> 56);
    }

    public static void int4(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
        byArray[n + 2] = (byte)(n2 >>> 16);
        byArray[n + 3] = (byte)(n2 >>> 24);
    }

    public static void int2(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
    }

    public static void float4(byte[] byArray, int n, float f) {
        ByteConverter.int4(byArray, n, Float.floatToRawIntBits(f));
    }

    public static void float8(byte[] byArray, int n, double d) {
        ByteConverter.int8(byArray, n, Double.doubleToRawLongBits(d));
    }

    public static BigDecimal adjustNumber(BigDecimal bigDecimal) {
        if (bigDecimal.precision() <= 38) {
            return bigDecimal;
        }
        int n = bigDecimal.scale();
        int n2 = n - (bigDecimal.precision() - 38);
        bigDecimal = new BigDecimal(bigDecimal.toPlainString());
        bigDecimal = bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        return bigDecimal;
    }

    public static int bigDecimalToBytes(byte[] byArray, int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = -bigDecimal.scale();
        int n3 = bigDecimal.signum();
        byte[] byArray2 = n3 < 0 ? bigDecimal.negate().unscaledValue().toByteArray() : bigDecimal.unscaledValue().toByteArray();
        byte by = 0;
        if (n3 < 0) {
            by = (byte)(by | 1);
        }
        if (n2 > 124 || n2 < -131) {
            throw SQLError.createSQLException("Overflow Exception trying to bind " + bigDecimal, YasState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (n2 < 0) {
            by = (byte)(by | 2);
            n2 = -n2;
        }
        byArray[n++] = by;
        byArray[n++] = (byte)n2;
        for (int i = byArray2.length - 1; i >= 0; --i) {
            byArray[n++] = byArray2[i];
        }
        return byArray2.length + 2;
    }
}

