/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CharacterSet {
    public static Charset getCharSet(short s) {
        CharacterType characterType = CharacterType.values()[s];
        switch (characterType) {
            case ASCII: {
                return StandardCharsets.US_ASCII;
            }
            case UTF8: {
                return StandardCharsets.UTF_8;
            }
            case GBK: {
                return Charset.forName("GBK");
            }
            case ISO88591: {
                return StandardCharsets.ISO_8859_1;
            }
            case UTF16: {
                return StandardCharsets.UTF_16LE;
            }
            case GB18030: {
                return Charset.forName("GB18030");
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)characterType));
    }

    static enum CharacterType {
        ASCII,
        GBK,
        UTF8,
        ISO88591,
        UTF16,
        GB18030;

    }
}

