/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.HaPrimaryConnector;
import com.yashandb.util.HaStandbyConnector;
import com.yashandb.util.HostConnector;
import com.yashandb.util.LoadBalanceConnector;
import com.yashandb.util.Messages;
import com.yashandb.util.StandAloneConnector;
import java.sql.SQLException;

public class ConnectorFactory {
    private ConnectorFactory() {
    }

    public static HostConnector generateConnector(SessionImpl sessionImpl, HostSpec[] hostSpecArray, String string) throws SQLException {
        if (hostSpecArray == null) {
            return null;
        }
        switch (string) {
            case "StandAlone": {
                if (hostSpecArray.length != 1) {
                    throw SQLError.createSQLException(Messages.get("Please specify the specific serverType in multi IP scenarios", new Object[0]), YasState.DATA_ERROR);
                }
                return new StandAloneConnector(sessionImpl, hostSpecArray[0]);
            }
            case "primary": {
                return new HaPrimaryConnector(sessionImpl, hostSpecArray);
            }
            case "loadBalance": {
                return new LoadBalanceConnector(sessionImpl, hostSpecArray);
            }
            case "standby": {
                return new HaStandbyConnector(sessionImpl, hostSpecArray);
            }
        }
        throw SQLError.createSQLException(Messages.get("invalid serverType: {0}", string), YasState.DATA_ERROR);
    }
}

