/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.DownHostsCache;
import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public abstract class HaConnector
extends HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaConnector.class.getName());
    private HostSpec[] hostSpecs;
    private int hostIndex = 0;
    private static final String CONNECT_MSG = "Connect Failed, spend time: {0} ms";

    protected HaConnector(SessionImpl sessionImpl, HostSpec[] hostSpecArray) {
        super(sessionImpl);
        this.hostSpecs = hostSpecArray;
    }

    private HostSpec a() {
        if (this.hostIndex >= this.hostSpecs.length) {
            return this.hostSpecs[this.hostSpecs.length - 1];
        }
        return this.hostSpecs[this.hostIndex++];
    }

    private boolean b() {
        return this.hostIndex < this.hostSpecs.length;
    }

    private void c() {
        if (this.hostSpecs.length > 1) {
            DownHostsCache.getInstance().reorderHosts(this.hostSpecs);
        }
        this.hostIndex = 0;
    }

    public abstract boolean isKeyHost() throws SQLException;

    @Override
    public void connect(String string, Properties properties) throws SQLException {
        long l;
        SocketFactory socketFactory = SocketFactory.getDefault();
        this.c();
        long l2 = l = System.currentTimeMillis();
        long l3 = Utils.toMillisecond(YasProperty.POOL_TIMEOUT.getInt(properties));
        while (true) {
            block3: {
                HostSpec hostSpec = this.a();
                LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
                try {
                    this.yasSocketConnection = this.tryConnect(string, properties, socketFactory, hostSpec);
                    if (this.isKeyHost()) break;
                    this.closeStream(this.yasSocketConnection);
                }
                catch (Exception exception) {
                    l2 = System.currentTimeMillis();
                    DownHostsCache.getInstance().markDownHost(hostSpec);
                    LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", hostSpec, exception.getMessage(), l2 - l);
                    if (this.b() || l2 - l <= l3) break block3;
                    String string2 = Messages.get(CONNECT_MSG, l2 - l);
                    LOGGER.error(string2);
                    this.closeStream(this.yasSocketConnection);
                    throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)exception);
                }
            }
            this.a(l, l2, l3);
            l2 = System.currentTimeMillis();
        }
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
    }

    private void a(long l, long l2, long l3) throws YasException {
        if (!this.b()) {
            if (l2 - l > l3) {
                String string = Messages.get(CONNECT_MSG, l2 - l);
                LOGGER.error(string);
                throw SQLError.createSQLException(string, YasState.CONNECTION_UNABLE_TO_CONNECT);
            }
            this.c();
            try {
                Thread.sleep(Utils.toMillisecond(2));
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Thread Interrupted");
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public YasLinkInfo failoverConnect(String string, Properties properties) throws SQLException {
        Object object;
        long l;
        SocketFactory socketFactory = SocketFactory.getDefault();
        if (!this.b()) {
            this.c();
        }
        long l2 = l = System.currentTimeMillis();
        long l3 = Utils.toMillisecond(YasProperty.POOL_TIMEOUT.getInt(properties));
        while (true) {
            object = this.a();
            LOGGER.debug("Trying to establish a connection to {}", object);
            try {
                this.yasSocketConnection = this.tryConnect(string, properties, socketFactory, (HostSpec)object);
                boolean bl = this.isKeyHost();
                if (!bl) {
                    this.closeStream(this.yasSocketConnection);
                }
                if (bl || object == this.session.getHostSpec()) {
                    break;
                }
            }
            catch (Exception exception) {
                l2 = this.a(l, l3, (HostSpec)object, exception);
            }
            if (!this.b()) {
                if (l2 - l > l3) {
                    String string2 = Messages.get(CONNECT_MSG, l2 - l);
                    LOGGER.error(string2);
                    throw SQLError.createSQLException(string2, YasState.CONNECTION_UNABLE_TO_CONNECT);
                }
                this.c();
            }
            l2 = System.currentTimeMillis();
        }
        object = new YasLinkInfo();
        ((YasLinkInfo)object).setProtocol(this.protocol);
        ((YasLinkInfo)object).setYasSocketConnection(this.yasSocketConnection);
        return object;
    }

    private long a(long l, long l2, HostSpec hostSpec, Exception exception) throws YasException {
        long l3 = System.currentTimeMillis();
        DownHostsCache.getInstance().markDownHost(hostSpec);
        LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", hostSpec, exception.getMessage(), l3 - l);
        if (!this.b() && l3 - l > l2) {
            String string = Messages.get(CONNECT_MSG, l3 - l);
            LOGGER.error(string);
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)exception);
        }
        return l3;
    }
}

