/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.ConnectionServerMode;
import com.yashandb.protocol.NativeProtocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public abstract class HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostConnector.class.getName());
    public static final String CONNECT_FAILED_MSG = "Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}";
    protected NativeProtocol protocol;
    protected YasSocketConnection yasSocketConnection;
    protected SessionImpl session;
    protected ConnectionServerMode serverMode = ConnectionServerMode.SHARED_MODE;

    protected HostConnector(SessionImpl sessionImpl) {
        this.session = sessionImpl;
    }

    public abstract void connect(String var1, Properties var2) throws SQLException;

    public abstract YasLinkInfo failoverConnect(String var1, Properties var2) throws SQLException;

    protected void closeStream(YasSocketConnection yasSocketConnection) {
        if (yasSocketConnection != null) {
            try {
                yasSocketConnection.close();
            }
            catch (IOException iOException) {
                LOGGER.debug("closeStream error");
            }
        }
    }

    public void checkConfigurations(Properties properties) throws SQLException {
        int n = YasProperty.CONNECT_TIMEOUT.getInt(properties);
        if (n < 0) {
            throw SQLError.createSQLException(Messages.get("connectTimeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        int n2 = YasProperty.LOGIN_TIMEOUT.getInt(properties);
        if (n2 < 0) {
            throw SQLError.createSQLException(Messages.get("loginTimeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        int n3 = YasProperty.SOCKET_TIMEOUT.getInt(properties);
        if (n3 < 0) {
            throw SQLError.createSQLException(Messages.get("socketTimeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        int n4 = YasProperty.POOL_TIMEOUT.getInt(properties);
        if (n4 <= 0) {
            throw SQLError.createSQLException(Messages.get("poolTimeout must be a value greater than 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.serverMode = ConnectionServerMode.getServerMode(YasProperty.SERVER_MODE.get(properties));
    }

    protected YasSocketConnection tryConnect(String string, Properties properties, SocketFactory socketFactory, HostSpec hostSpec) throws SQLException, IOException {
        int n = Utils.toMillisecond(YasProperty.CONNECT_TIMEOUT.getInt(properties));
        YasSocketConnection yasSocketConnection = null;
        try {
            int n2;
            yasSocketConnection = new YasSocketConnection(socketFactory, hostSpec, n);
            int n3 = Utils.toMillisecond(YasProperty.SOCKET_TIMEOUT.getInt(properties));
            if (n3 > 0) {
                yasSocketConnection.getSocket().setSoTimeout(n3);
            }
            boolean bl = YasProperty.TCP_KEEP_ALIVE.getBoolean(properties);
            yasSocketConnection.getSocket().setKeepAlive(bl);
            int n4 = YasProperty.RECEIVE_BUFFER_SIZE.getInt(properties);
            if (n4 > -1) {
                if (n4 > 0) {
                    yasSocketConnection.getSocket().setReceiveBufferSize(n4);
                } else {
                    LOGGER.warn("Ignore invalid value for receiveBufferSize: {}", (Object)n4);
                }
            }
            if ((n2 = YasProperty.SEND_BUFFER_SIZE.getInt(properties)) > -1) {
                if (n2 > 0) {
                    yasSocketConnection.getSocket().setSendBufferSize(n2);
                } else {
                    LOGGER.warn("Ignore invalid value for sendBufferSize: {}", (Object)n2);
                }
            }
            LOGGER.debug("Receive Buffer Size is {}", (Object)yasSocketConnection.getSocket().getReceiveBufferSize());
            LOGGER.debug("Send Buffer Size is {}", (Object)yasSocketConnection.getSocket().getSendBufferSize());
            String string2 = YasProperty.PASSWORD.get(properties);
            this.protocol = new NativeProtocol(this.session, yasSocketConnection);
            this.protocol.setServerMode(this.serverMode);
            this.protocol.connect(string, string2, properties);
            return yasSocketConnection;
        }
        catch (Exception exception) {
            if (yasSocketConnection != null) {
                yasSocketConnection.close();
            }
            throw exception;
        }
    }
}

