/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.NativeProtocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.net.SocketFactory;

public class LoadBalanceConnector
extends HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalanceConnector.class.getName());
    private HostSpec[] hostSpecs;
    private final Map connectedSockets = new TreeMap();

    public LoadBalanceConnector(SessionImpl sessionImpl, HostSpec[] hostSpecArray) {
        super(sessionImpl);
        this.yasSocketConnection = null;
        this.hostSpecs = hostSpecArray;
    }

    private int a() throws SQLException {
        String string = "select count(*) from v$session where type!='BACKGROUND'";
        int n = 0;
        Statement statement = this.session.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (!resultSet.next()) {
            resultSet.close();
            return n;
        }
        n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect(String string, Properties properties) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        for (HostSpec hostSpec : this.hostSpecs) {
            LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
            Object object = null;
            long l = System.currentTimeMillis();
            try {
                object = this.tryConnect(string, properties, socketFactory, hostSpec);
                this.session.setYasSocketConnection((YasSocketConnection)object);
                this.session.setProtocol(this.protocol);
                int n = this.a();
                if (!this.connectedSockets.containsKey(n)) {
                    LinkedList linkedList = new LinkedList();
                    this.connectedSockets.put(n, linkedList);
                }
                ((LinkedList)this.connectedSockets.get(n)).add(this.protocol);
            }
            catch (Exception exception) {
                long l2 = System.currentTimeMillis();
                LOGGER.warn("Connect to hostSpec {} failed, Exception: {},spend time: {} ", hostSpec, exception.getMessage(), l2 - l);
                this.closeStream((YasSocketConnection)object);
            }
        }
        if (this.connectedSockets.isEmpty()) {
            String n = Messages.get("Connect Failed.", new Object[0]);
            LOGGER.error(n);
            throw SQLError.createSQLException(n, YasState.CONNECTION_UNABLE_TO_CONNECT);
        }
        boolean bl = false;
        for (Map.Entry entry : this.connectedSockets.entrySet()) {
            LinkedList linkedList = (LinkedList)entry.getValue();
            for (NativeProtocol nativeProtocol : linkedList) {
                void var4_7;
                if (var4_7 == false) {
                    this.yasSocketConnection = nativeProtocol.getSocketConnection();
                    this.protocol = nativeProtocol;
                    ++var4_7;
                    continue;
                }
                this.closeStream(nativeProtocol.getSocketConnection());
                ++var4_7;
            }
            linkedList.clear();
        }
        this.connectedSockets.clear();
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public YasLinkInfo failoverConnect(String string, Properties properties) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        for (HostSpec hostSpec : this.hostSpecs) {
            LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
            Object object = null;
            long l = System.currentTimeMillis();
            try {
                object = this.tryConnect(string, properties, socketFactory, hostSpec);
                this.session.setYasSocketConnection((YasSocketConnection)object);
                this.session.setProtocol(this.protocol);
                int n = this.a();
                if (!this.connectedSockets.containsKey(n)) {
                    LinkedList linkedList = new LinkedList();
                    this.connectedSockets.put(n, linkedList);
                }
                ((LinkedList)this.connectedSockets.get(n)).add(this.protocol);
            }
            catch (Exception exception) {
                long l2 = System.currentTimeMillis();
                LOGGER.warn("Connect to hostSpec {} failed, Exception: {},spend time: {} ", hostSpec, exception.getMessage(), l2 - l);
                this.closeStream((YasSocketConnection)object);
            }
        }
        if (this.connectedSockets.isEmpty()) {
            String n = Messages.get("Connect Failed.", new Object[0]);
            LOGGER.error(n);
            throw SQLError.createSQLException(n, YasState.CONNECTION_UNABLE_TO_CONNECT);
        }
        boolean bl = false;
        for (Map.Entry entry : this.connectedSockets.entrySet()) {
            LinkedList linkedList = (LinkedList)entry.getValue();
            for (NativeProtocol nativeProtocol : linkedList) {
                void var4_7;
                if (var4_7 == false || this.yasSocketConnection.getHostSpec() == this.session.getHostSpec()) {
                    if (var4_7 != false) {
                        this.closeStream(this.yasSocketConnection);
                    }
                    this.yasSocketConnection = nativeProtocol.getSocketConnection();
                    this.protocol = nativeProtocol;
                    ++var4_7;
                    continue;
                }
                this.closeStream(nativeProtocol.getSocketConnection());
                ++var4_7;
            }
            linkedList.clear();
        }
        this.connectedSockets.clear();
        YasLinkInfo yasLinkInfo = new YasLinkInfo();
        yasLinkInfo.setProtocol(this.protocol);
        yasLinkInfo.setYasSocketConnection(this.yasSocketConnection);
        return yasLinkInfo;
    }
}

