/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public class StandAloneConnector
extends HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandAloneConnector.class.getName());
    private HostSpec hostSpec;

    public StandAloneConnector(SessionImpl sessionImpl, HostSpec hostSpec) {
        super(sessionImpl);
        this.hostSpec = hostSpec;
    }

    @Override
    public void connect(String string, Properties properties) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        long l = System.currentTimeMillis();
        LOGGER.debug("Trying to establish a connection to {}", (Object)this.hostSpec);
        try {
            this.yasSocketConnection = this.tryConnect(string, properties, socketFactory, this.hostSpec);
        }
        catch (ConnectException connectException) {
            long l2 = System.currentTimeMillis();
            LOGGER.error("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", this.hostSpec, connectException.getMessage(), l2 - l);
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("Connection to {0} refused. Check that the hostname and port are correct", this.hostSpec), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)connectException);
        }
        catch (IOException iOException) {
            long l3 = System.currentTimeMillis();
            LOGGER.error("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", this.hostSpec, iOException.getMessage(), l3 - l);
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            long l4 = System.currentTimeMillis();
            LOGGER.error("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", this.hostSpec, sQLException.getMessage(), l4 - l);
            this.closeStream(this.yasSocketConnection);
            throw sQLException;
        }
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
    }

    @Override
    public YasLinkInfo failoverConnect(String string, Properties properties) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        long l = System.currentTimeMillis();
        LOGGER.debug("Trying to establish a connection to {}", (Object)this.hostSpec);
        try {
            this.yasSocketConnection = this.tryConnect(string, properties, socketFactory, this.hostSpec);
        }
        catch (ConnectException connectException) {
            long l2 = System.currentTimeMillis();
            LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", this.hostSpec, connectException.getMessage(), l2 - l);
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("Connection to {0} refused. Check that the hostname and port are correct", this.hostSpec), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)connectException);
        }
        catch (IOException iOException) {
            long l3 = System.currentTimeMillis();
            LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", this.hostSpec, iOException.getMessage(), l3 - l);
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            long l4 = System.currentTimeMillis();
            LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {}", this.hostSpec, sQLException.getMessage(), l4 - l);
            this.closeStream(this.yasSocketConnection);
            throw sQLException;
        }
        YasLinkInfo yasLinkInfo = new YasLinkInfo();
        yasLinkInfo.setProtocol(this.protocol);
        yasLinkInfo.setYasSocketConnection(this.yasSocketConnection);
        return yasLinkInfo;
    }
}

