/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.SQLException;

public class Utils {
    private Utils() {
    }

    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append((char)Utils.nibbleToHex((byte)((by & 0xF0) >> 4)));
            stringBuilder.append((char)Utils.nibbleToHex((byte)(by & 0xF)));
        }
        return stringBuilder.toString();
    }

    public static byte nibbleToHex(byte by) {
        return (byte)((by = (byte)(by & 0xF)) < 10 ? by + 48 : by - 10 + 65);
    }

    public static StringBuilder escapeLiteral(StringBuilder stringBuilder, String string, boolean bl) throws SQLException {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder((string.length() + 10) / 10 * 11);
        }
        Utils.a(stringBuilder, string, bl);
        return stringBuilder;
    }

    private static void a(Appendable appendable, String string, boolean bl) throws SQLException {
        try {
            if (bl) {
                Utils.a(appendable, string);
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\u0000') {
                        throw SQLError.createSQLException(Messages.get("Zero bytes may not occur in string parameters.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
                    }
                    if (c == '\\' || c == '\'') {
                        appendable.append(c);
                    }
                    appendable.append(c);
                }
            }
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("No IOException expected from StringBuffer or StringBuilder", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    private static void a(Appendable appendable, String string) throws YasException, IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                throw SQLError.createSQLException(Messages.get("Zero bytes may not occur in string parameters.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
            }
            if (c == '\'') {
                appendable.append('\'');
            }
            appendable.append(c);
        }
    }

    public static String trimString(String string) {
        if (string != null) {
            return string.trim();
        }
        return string;
    }

    public static long[] toLongArray(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    public static int[] toIntArray(long[] lArray) {
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    public static int toMillisecond(int n) {
        int n2 = n * 1000;
        if (n < 0) {
            return 0;
        }
        if (n2 < 0) {
            return Integer.MAX_VALUE;
        }
        return n2;
    }

    public static void append4Byte(StringBuilder stringBuilder, int n) {
        if (n >= 100 && n < 1000) {
            stringBuilder.append("0");
        } else if (n >= 10 && n < 100) {
            stringBuilder.append("00");
        } else if (n < 10) {
            stringBuilder.append("000");
        }
        stringBuilder.append(n);
    }

    public static void appendTimeStampFraction(StringBuilder stringBuilder, int n) {
        if (n < 100000 && n >= 10000) {
            stringBuilder.append("0");
        } else if (n < 10000 && n >= 1000) {
            stringBuilder.append("00");
        } else if (n < 1000 && n >= 100) {
            stringBuilder.append("000");
        } else if (n >= 10 && n < 100) {
            stringBuilder.append("0000");
        } else if (n < 10 && n != 0) {
            stringBuilder.append("00000");
        }
        while (n % 10 == 0 && n != 0) {
            n /= 10;
        }
        stringBuilder.append(n);
    }

    public static void append2Byte(StringBuilder stringBuilder, int n) {
        if (n < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n);
    }

    public static String getRandomString(int n) {
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int n2 = secureRandom.nextInt(62);
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static boolean checkFileExists(String string) {
        File file = new File(string);
        return file.exists();
    }
}

