/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.jni.GmEncryptDll;
import com.yashandb.util.Utils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class YasEncrypt {
    private static final Logger LOGGER = LoggerFactory.getLogger(YasEncrypt.class.getName());
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String CIPHER_ALGORITHM = "AES/CBC/NoPadding";
    private static final String ALGORITHM = "AES";
    private static final byte[] IV_PARAMETER = "0000000000000000".getBytes(CHARSET);
    private static final int ENCRY_VERSION_PALIN = 0;
    private static final int ENCRY_VERSION_SHA256 = 1;
    private static final int ENCRY_VERSION_SM3 = 2;
    private static final int TRANS_ENCRY_VERSION = 1;
    private static final int TRANS_PALIN_VERSION = 2;
    public static final int SYM_ENCRY_VERSION_SM4_CBC = 3;
    private static final int AES_ZERO_PADDING_LENGTH = 16;
    private static final int BLOCK_SIZE = 16;

    private YasEncrypt() {
    }

    public static String encryptSHA(String string, String string2, int n) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = YasEncrypt.a(string, string2, "SHA-256");
                break;
            }
            case 2: {
                string3 = YasEncrypt.a(string, string2);
                break;
            }
            case 0: {
                string3 = string;
                break;
            }
            default: {
                string3 = YasEncrypt.a(string, string2, "SHA-256");
            }
        }
        return string3;
    }

    public static byte[] encrypt(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = null;
        switch (n) {
            case 1: {
                byArray3 = YasEncrypt.a(byArray, byArray2);
                break;
            }
            case 2: {
                byArray3 = byArray;
                break;
            }
            default: {
                byArray3 = YasEncrypt.a(byArray, byArray2);
            }
        }
        return byArray3;
    }

    public static byte[] decrypt(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = null;
        switch (n) {
            case 1: {
                byArray3 = YasEncrypt.b(byArray, byArray2);
                break;
            }
            case 2: {
                byArray3 = byArray;
                break;
            }
            default: {
                byArray3 = YasEncrypt.b(byArray, byArray2);
            }
        }
        return byArray3;
    }

    private static String a(String string, String string2, String string3) {
        MessageDigest messageDigest = null;
        String string4 = null;
        try {
            byte[] byArray;
            messageDigest = MessageDigest.getInstance(string3);
            byte[] byArray2 = string.getBytes(CHARSET);
            messageDigest.update(byArray2);
            if (string2 != null) {
                byArray = string2.getBytes(CHARSET);
                messageDigest.update(byArray);
            }
            byArray = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                if (n < 16) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toHexString(n));
            }
            string4 = stringBuilder.toString();
            string4 = string4.toUpperCase();
        }
        catch (Exception exception) {
            LOGGER.error("No such SHA Algorithm or unsupport encoding.", exception);
            return null;
        }
        return string4;
    }

    private static String a(String string, String string2) {
        try {
            long l = GmEncryptDll.sm3CtxNew();
            YasEncrypt.a();
            GmEncryptDll.sm3Init(l);
            GmEncryptDll.sm3Update(l, string.getBytes(), 0, string.getBytes().length);
            GmEncryptDll.sm3Update(l, string2.getBytes(), 0, string2.getBytes().length);
            byte[] byArray = new byte[32];
            GmEncryptDll.sm3Finish(l, byArray);
            GmEncryptDll.sm3CtxFree(l);
            return Utils.toHexString(byArray);
        }
        catch (Exception exception) {
            LOGGER.error("No such SHA Algorithm or unsupport encoding.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        if (GmEncryptDll.hasAddHook.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = GmEncryptDll.hasAddHook;
        synchronized (atomicBoolean) {
            if (GmEncryptDll.hasAddHook.get()) {
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GmEncryptDll.releaseEnv();
                }
            });
            GmEncryptDll.hasAddHook.set(true);
        }
    }

    private static byte[] a(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 16) {
            byArray = Arrays.copyOf(byArray, 16);
        }
        if (byArray2 == null) {
            return null;
        }
        SecretKeySpec secretKeySpec = null;
        try {
            byArray2 = YasEncrypt.a(byArray2, 16);
            secretKeySpec = new SecretKeySpec(byArray, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(IV_PARAMETER);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            LOGGER.error("Encrypt AES failed.data:" + byArray2.length + "," + new String(byArray2) + ",password: " + byArray.length + "," + new String(byArray) + ",secretKey: " + (secretKeySpec == null ? "" : new String(secretKeySpec.getEncoded())), exception);
            return byArray2;
        }
    }

    public static byte[] encryptSM4(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        if (byArray2 == null) {
            return null;
        }
        byte[] byArray3 = GmEncryptDll.sm4CbcEncryptPadding(byArray, IV_PARAMETER, byArray2);
        YasEncrypt.a();
        return byArray3;
    }

    private static byte[] b(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length > 16) {
            byArray = Arrays.copyOf(byArray, 16);
        }
        if (byArray2 == null) {
            return null;
        }
        if (byArray2.length < 16) {
            byArray2 = Arrays.copyOf(byArray2, 16);
        }
        SecretKeySpec secretKeySpec = null;
        try {
            secretKeySpec = new SecretKeySpec(byArray, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(IV_PARAMETER);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray2);
            byArray3 = YasEncrypt.b(byArray3, 16);
            return byArray3;
        }
        catch (Exception exception) {
            LOGGER.error("Decrypt AES failed.data:" + byArray2.length + "," + new String(byArray2) + ",password: " + byArray.length + "," + new String(byArray) + ",secretKey: " + (secretKeySpec == null ? " " : new String(secretKeySpec.getEncoded())), exception);
            return byArray2;
        }
    }

    private static byte[] a(byte[] byArray, int n) {
        byte[] byArray2 = null;
        if (byArray == null) {
            return byArray;
        }
        byArray2 = byArray.length % n != 0 ? Arrays.copyOf(byArray, byArray.length + n - byArray.length % n) : byArray;
        return byArray2;
    }

    private static byte[] b(byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = null;
        if (byArray == null) {
            return byArray;
        }
        int n3 = byArray.length;
        for (n2 = 0; n2 < n - 1 && n3 - 1 - n2 > 0 && byArray[n3 - 1 - n2] == 0; ++n2) {
        }
        byArray2 = n2 > 0 ? Arrays.copyOf(byArray, byArray.length - n2) : byArray;
        return byArray2;
    }
}

