/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class YasTime
extends Time {
    private static final int NANOS_IN_SECOND = 1000000000;
    private static final int MILLS_IN_SECOND = 1000;
    private static final int NANOS_IN_MILLISECOND = 1000000;
    private Calendar calendar;
    private int nanosecond;

    public YasTime(long l) {
        this(l, null);
    }

    public YasTime(long l, Calendar calendar) {
        super(l / 1000L * 1000L);
        this.setCalendar(calendar);
        this.nanosecond = (int)(l % 1000L * 1000000L);
        if (this.nanosecond < 0) {
            this.nanosecond = 1000000000 + this.nanosecond;
            super.setTime((l / 1000L - 1L) * 1000L);
        }
    }

    @Override
    public long getTime() {
        long l = super.getTime();
        return l + (long)(this.nanosecond / 1000000);
    }

    @Override
    public void setTime(long l) {
        super.setTime(l / 1000L * 1000L);
        this.nanosecond = (int)(l % 1000L * 1000000L);
        if (this.nanosecond < 0) {
            this.nanosecond = 1000000000 + this.nanosecond;
            super.setTime((l / 1000L - 1L) * 1000L);
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2;
        int n3 = this.calendar == null ? 0 : this.calendar.hashCode();
        return n2 += n3;
    }

    public boolean equals(YasTime yasTime) {
        return this.toString().equals(yasTime.toString());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YasTime)) {
            return false;
        }
        return this.equals((YasTime)object);
    }

    @Override
    public String toString() {
        String string;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        String string2 = "000000000";
        String string3 = n < 10 ? "0" + n : Integer.toString(n);
        String string4 = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string5 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        if (this.nanosecond == 0) {
            string = "000000";
        } else {
            string = Integer.toString(this.nanosecond);
            string = string2.substring(0, 9 - string.length()) + string;
            string = string.substring(0, 6);
        }
        StringBuilder stringBuilder = new StringBuilder(20 + string.length());
        stringBuilder.append(string3);
        stringBuilder.append(":");
        stringBuilder.append(string4);
        stringBuilder.append(":");
        stringBuilder.append(string5);
        stringBuilder.append(".");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public void setNanos(int n) {
        if (n > 999999999 || n < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanosecond = n;
    }

    public int getNanos() {
        return this.nanosecond;
    }

    public static YasTime valueOf(LocalTime localTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, localTime.getHour());
        calendar.set(12, localTime.getMinute());
        calendar.set(13, localTime.getSecond());
        long l = localTime.toNanoOfDay();
        YasTime yasTime = new YasTime(calendar.getTimeInMillis());
        yasTime.setNanos((int)(l % 1000000000L));
        return yasTime;
    }

    public static Time valueOf(String string) {
        return YasTime.valueOf(LocalTime.parse(string, DateTimeFormatter.ISO_LOCAL_TIME));
    }

    @Override
    public LocalTime toLocalTime() {
        return super.toLocalTime().withNano(this.getNanos());
    }
}

