/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.xa;

import com.yashandb.Session;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.pool.YasPooledConnection;
import com.yashandb.xa.YasXAException;
import com.yashandb.xa.YasXid;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class YasXAConnection
extends YasPooledConnection
implements XAConnection,
XAResource {
    private final Session session;
    private int transactionTimeout = 60;
    public static final byte XA_START_CODE = 1;
    public static final byte XA_END_CODE = 2;
    public static final byte XA_FORGET_CODE = 3;
    public static final byte XA_PREPARE_CODE = 4;
    public static final byte XA_COMMIT_CODE = 5;
    public static final byte XA_ROLLBACK_CODE = 6;
    public static final byte XA_RECOVER_CODE = 7;

    public YasXAConnection(Connection connection) {
        super(connection);
        this.session = ((YasConnection)connection).getSession();
    }

    public static Xid encodeXid(byte[] byArray) throws XAException {
        if (byArray.length != 128) {
            throw new YasXAException("Incorrect format", -4, 0);
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 64);
        byte[] byArray3 = Arrays.copyOfRange(byArray, 64, 128);
        return new YasXid(0, byArray2, byArray3);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            this.session.xaCommit(xid, bl ? 0x40000000 : 0, this.getTransactionTimeout());
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 5);
        }
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        try {
            if (n != 0x4000000 && n != 0x20000000 && n != 0x2000000) {
                throw new YasXAException("invalid flag", -5, 0);
            }
            this.session.xaEnd(xid, n, this.getTransactionTimeout());
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 2);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        try {
            this.session.xaForget(xid, this.getTransactionTimeout());
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 3);
        }
    }

    @Override
    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof YasXAConnection)) {
            return false;
        }
        if (this == xAResource) {
            return true;
        }
        return ((YasXAConnection)xAResource).session.getHostSpec().equals(this.session.getHostSpec());
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.session.xaPrepare(xid, this.getTransactionTimeout());
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 4);
        }
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        if (n != 0x1000000 && n != 0x800000 && n != 0) {
            throw new YasXAException("Illegal flags", -5, 0);
        }
        try {
            Statement statement = this.physicalConn.createStatement();
            LinkedList<Xid> linkedList = new LinkedList<Xid>();
            ResultSet resultSet = statement.executeQuery("select * from v$2pc_pending");
            while (resultSet.next()) {
                linkedList.add(YasXAConnection.encodeXid(resultSet.getBytes(1)));
            }
            return linkedList.toArray(new Xid[0]);
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 7);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.session.xaRollback(xid, this.getTransactionTimeout());
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 6);
        }
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        this.transactionTimeout = n;
        return true;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        try {
            if (n != 0 && n != 0x200000 && n != 0x8000000) {
                throw new YasXAException("invalid flag", -5, 0);
            }
            this.session.xaStart(xid, n, this.getTransactionTimeout());
        }
        catch (SQLException sQLException) {
            throw new YasXAException(sQLException, 1);
        }
    }

    public static void checkXid(Xid xid) throws XAException {
        if (xid == null) {
            throw new YasXAException("Xid cannot be null", -4, 0);
        }
        if (xid.getBranchQualifier().length > 64) {
            throw new YasXAException("bqual length cannot exceed 64", -4, 0);
        }
        if (xid.getGlobalTransactionId().length > 64) {
            throw new YasXAException("gtrid length cannot exceed 64", -4, 0);
        }
    }
}

