/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.data.jsonparsable;

import android.content.Context;
import android.util.JsonReader;
import android.util.JsonToken;
import com.yashoid.data.jsonparsable.JSONParsable;
import com.yashoid.data.jsonparsable.JsonField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONParser {
    public static final String DONT_SET = "dont_set";
    private static JSONParser mInstance = null;
    private Context mContext;

    public static JSONParser getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new JSONParser(context);
        }
        return mInstance;
    }

    private JSONParser(Context context) {
        this.mContext = context;
    }

    public JSONParsable parse(JsonReader reader, JSONFieldParser parser) throws Exception {
        reader.beginObject();
        Object object = this.createInstance(parser.clazz);
        while (reader.hasNext()) {
            String name = reader.nextName();
            FieldTypeMap map = (FieldTypeMap)parser.map.get(name);
            if (map != null) {
                Field field = map.field;
                String type = map.type;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                if ("str".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        this.onFieldParsed((JSONParsable)object, field, name, reader.nextString());
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, null);
                    }
                } else if ("int".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        this.onFieldParsed((JSONParsable)object, field, name, reader.nextInt());
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, DONT_SET);
                    }
                } else if ("lng".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        this.onFieldParsed((JSONParsable)object, field, name, reader.nextLong());
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, DONT_SET);
                    }
                } else if ("flt".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        this.onFieldParsed((JSONParsable)object, field, name, Float.valueOf((float)reader.nextDouble()));
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, DONT_SET);
                    }
                } else if ("dbl".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        this.onFieldParsed((JSONParsable)object, field, name, reader.nextDouble());
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, DONT_SET);
                    }
                } else if ("bln".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        this.onFieldParsed((JSONParsable)object, field, name, reader.nextBoolean());
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, DONT_SET);
                    }
                } else if ("arl".equals(type)) {
                    if (reader.peek() != JsonToken.NULL) {
                        ArrayList list = (ArrayList)field.get(object);
                        this.parseArray(reader, list, map.subType, parser);
                        this.onFieldParsed((JSONParsable)object, field, name, list);
                    } else {
                        reader.nextNull();
                        this.onFieldParsed((JSONParsable)object, field, name, null);
                    }
                } else if (reader.peek() != JsonToken.NULL) {
                    Class<?> subClazz = parser.classLoader.loadClass(type);
                    JSONFieldParser subParser = JSONFieldParser.newInstance(subClazz);
                    JSONParsable subObject = this.parse(reader, subParser);
                    this.onFieldParsed((JSONParsable)object, field, name, subObject);
                } else {
                    reader.nextNull();
                    this.onFieldParsed((JSONParsable)object, field, name, null);
                }
                field.setAccessible(accessible);
                continue;
            }
            if (object.onUnknownName(name, reader, this.mContext)) continue;
            reader.skipValue();
        }
        reader.endObject();
        return object;
    }

    public <T extends JSONParsable> void parseArray(JsonReader reader, ArrayList<T> list, JSONFieldParser parser) throws Exception {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            JSONParsable object = this.parse(reader, parser);
            list.add(object);
        }
        reader.endArray();
    }

    private void parseArray(JsonReader reader, ArrayList<?> dest, String type, JSONFieldParser parser) throws Exception {
        reader.beginArray();
        if ("str".equals(type)) {
            ArrayList<?> list = dest;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(reader.nextString());
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        } else if ("int".equals(type)) {
            ArrayList<?> list = dest;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(reader.nextInt());
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        } else if ("lng".equals(type)) {
            ArrayList<?> list = dest;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(reader.nextLong());
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        } else if ("flt".equals(type)) {
            ArrayList<?> list = dest;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(Float.valueOf((float)reader.nextDouble()));
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        } else if ("dbl".equals(type)) {
            ArrayList<?> list = dest;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(reader.nextDouble());
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        } else if ("bln".equals(type)) {
            ArrayList<?> list = dest;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(reader.nextBoolean());
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        } else {
            if ("arl".equals(type)) {
                throw new IllegalArgumentException("Array inside array is not supported.");
            }
            ArrayList<?> list = dest;
            Class<?> subClazz = parser.classLoader.loadClass(type);
            JSONFieldParser subParser = JSONFieldParser.newInstance(subClazz);
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NULL) {
                    list.add(this.parse(reader, subParser));
                    continue;
                }
                reader.nextNull();
                list.add(null);
            }
        }
        reader.endArray();
    }

    public JSONParsable parse(JSONObject jObject, Class<? extends JSONParsable> clazz) throws Exception {
        return this.parse(jObject, clazz, clazz.getClassLoader());
    }

    public JSONParsable parse(JSONObject jObject, Class<? extends JSONParsable> clazz, ClassLoader classLoader) throws Exception {
        JSONParsable object = this.createInstance(clazz);
        ArrayList<Field> fields = new ArrayList<Field>();
        JSONParser.getFields(fields, clazz);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(JsonField.class)) continue;
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            JsonField jField = field.getAnnotation(JsonField.class);
            String jFieldName = jField.name();
            String type = jField.type();
            if ("str".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    this.onFieldParsed(object, field, jFieldName, jObject.getString(jFieldName));
                } else {
                    this.onFieldParsed(object, field, jFieldName, null);
                }
            } else if ("int".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    this.onFieldParsed(object, field, jFieldName, jObject.getInt(jFieldName));
                } else {
                    this.onFieldParsed(object, field, jFieldName, DONT_SET);
                }
            } else if ("lng".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    this.onFieldParsed(object, field, jFieldName, jObject.getLong(jFieldName));
                } else {
                    this.onFieldParsed(object, field, jFieldName, DONT_SET);
                }
            } else if ("flt".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    this.onFieldParsed(object, field, jFieldName, Float.valueOf((float)jObject.getDouble(jFieldName)));
                } else {
                    this.onFieldParsed(object, field, jFieldName, DONT_SET);
                }
            } else if ("dbl".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    this.onFieldParsed(object, field, jFieldName, jObject.getDouble(jFieldName));
                } else {
                    this.onFieldParsed(object, field, jFieldName, DONT_SET);
                }
            } else if ("bln".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    this.onFieldParsed(object, field, jFieldName, jObject.getBoolean(jFieldName));
                } else {
                    this.onFieldParsed(object, field, jFieldName, DONT_SET);
                }
            } else if ("arl".equals(type)) {
                if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                    JSONArray jArray = jObject.getJSONArray(jFieldName);
                    ArrayList list = (ArrayList)field.get(object);
                    String subType = jField.subType();
                    this.parseArray(jArray, list, subType, classLoader);
                    this.onFieldParsed(object, field, jFieldName, list);
                } else {
                    this.onFieldParsed(object, field, jFieldName, null);
                }
            } else if (jObject.has(jFieldName) && !jObject.isNull(jFieldName)) {
                JSONObject jSubObject = jObject.getJSONObject(jFieldName);
                Class<?> subClazz = classLoader.loadClass(type);
                this.onFieldParsed(object, field, jFieldName, this.parse(jSubObject, subClazz, classLoader));
            } else {
                this.onFieldParsed(object, field, jFieldName, null);
            }
            field.setAccessible(isAccessible);
        }
        return object;
    }

    private void onFieldParsed(JSONParsable parsingObject, Field field, String name, Object parsedField) throws IllegalAccessException, IllegalArgumentException {
        Object fieldValue = parsingObject.onFieldParsed(name, parsedField, this.mContext);
        if (fieldValue != DONT_SET && fieldValue != null) {
            field.set(parsingObject, fieldValue);
        }
    }

    private void parseArray(JSONArray source, ArrayList<?> dest, String type, ClassLoader classLoader) throws Exception {
        if ("str".equals(type)) {
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    list.add(source.getString(i));
                    continue;
                }
                list.add(null);
            }
        } else if ("int".equals(type)) {
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    list.add(source.getInt(i));
                    continue;
                }
                list.add(null);
            }
        } else if ("lng".equals(type)) {
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    list.add(source.getLong(i));
                    continue;
                }
                list.add(null);
            }
        } else if ("flt".equals(type)) {
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    list.add(Float.valueOf((float)source.getDouble(i)));
                    continue;
                }
                list.add(null);
            }
        } else if ("dbl".equals(type)) {
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    list.add(source.getDouble(i));
                    continue;
                }
                list.add(null);
            }
        } else if ("bln".equals(type)) {
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    list.add(source.getBoolean(i));
                    continue;
                }
                list.add(null);
            }
        } else {
            if ("arl".equals(type)) {
                throw new IllegalArgumentException("Array inside array is not supported.");
            }
            Class<?> clazz = classLoader.loadClass(type);
            ArrayList<?> list = dest;
            for (int i = 0; i < source.length(); ++i) {
                if (!source.isNull(i)) {
                    JSONObject jObject = source.getJSONObject(i);
                    list.add(this.parse(jObject, clazz, classLoader));
                    continue;
                }
                list.add(null);
            }
        }
    }

    private <T extends JSONParsable> T createInstance(Class<T> clazz) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        Field field = clazz.getField("JSONPARSABLE_CREATOR");
        JSONParsable.JsonParsableCreator creator = (JSONParsable.JsonParsableCreator)field.get(null);
        return creator.newInstance(this.mContext);
    }

    private static void getFields(ArrayList<Field> fields, Class<?> clazz) {
        Class<?> superClass;
        try {
            Field[] classFields;
            Class<?> parsableClass = clazz;
            for (Field field : classFields = parsableClass.getDeclaredFields()) {
                fields.add(field);
            }
        }
        catch (Throwable parsableClass) {
            // empty catch block
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            JSONParser.getFields(fields, superClass);
        }
    }

    public static class JSONFieldParser {
        private HashMap<String, FieldTypeMap> map;
        private Class<? extends JSONParsable> clazz;
        private ClassLoader classLoader;

        public static JSONFieldParser newInstance(Class<? extends JSONParsable> clazz) {
            return new JSONFieldParser(clazz, clazz.getClassLoader());
        }

        private JSONFieldParser(Class<? extends JSONParsable> clazz, ClassLoader classLoader) {
            this.clazz = clazz;
            this.classLoader = classLoader;
            ArrayList fields = new ArrayList();
            JSONParser.getFields(fields, clazz);
            this.map = new HashMap(fields.size());
            for (Field field : fields) {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.isAnnotationPresent(JsonField.class)) {
                    JsonField jField = field.getAnnotation(JsonField.class);
                    FieldTypeMap fieldTypeMap = new FieldTypeMap();
                    fieldTypeMap.field = field;
                    fieldTypeMap.type = jField.type();
                    fieldTypeMap.subType = jField.subType();
                    this.map.put(jField.name(), fieldTypeMap);
                }
                field.setAccessible(isAccessible);
            }
        }
    }

    private static class FieldTypeMap {
        private Field field;
        private String type;
        private String subType;

        private FieldTypeMap() {
        }
    }
}

