/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.network.request;

import com.yashoid.network.request.NetworkRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class MultipartBody
implements NetworkRequest.BodyLoader {
    private static final String BOUNDARY_WRAPPER = "===";
    private static final String CONTENT_TYPE = "multipart/form-data; boundary=";
    private static final String CHARSET = "UTF_8";
    private static final String STRING_PART_CONTENT_TYPE = "Content-Type: text/plain; charset=UTF_8\r\n";
    private HttpURLConnection mConnection;
    private OutputStream mOutputStream;
    private String mBoundary;
    private HashMap<String, Object> mParts;

    public MultipartBody(HttpURLConnection connection) {
        this.mConnection = connection;
        this.mBoundary = BOUNDARY_WRAPPER + System.currentTimeMillis() + BOUNDARY_WRAPPER;
        this.mParts = new HashMap(10);
        this.mConnection.setUseCaches(false);
        this.mConnection.setRequestProperty("Content-Type", this.getContentType());
    }

    public MultipartBody(NetworkRequest<?> request) {
        this(request.getConnection());
    }

    private String getContentType() {
        return CONTENT_TYPE + this.mBoundary;
    }

    public void addPart(String name, String value) {
        this.mParts.put(name, value);
    }

    public void addPart(String name, File value) {
        this.mParts.put(name, value);
    }

    @Override
    public void write(OutputStream output) throws IOException {
        this.mOutputStream = output;
        for (Map.Entry<String, Object> part : this.mParts.entrySet()) {
            String name = part.getKey();
            Object value = part.getValue();
            if (value instanceof String) {
                this.writeStringPart(name, (String)value);
            } else if (value instanceof File) {
                this.writeFilePart(name, (File)value);
            }
            this.mOutputStream.flush();
        }
        this.mOutputStream.write(("\r\n--" + this.mBoundary + "--\r\n").getBytes(CHARSET));
    }

    private void writeStringPart(String name, String value) throws IOException {
        this.writePartStart();
        this.mOutputStream.write(("Content-Disposition: form-data; name=\"" + name + "\"\r\n").getBytes(CHARSET));
        this.mOutputStream.write(STRING_PART_CONTENT_TYPE.getBytes(CHARSET));
        this.mOutputStream.write(("\r\n" + value + "\r\n").getBytes(CHARSET));
    }

    private void writeFilePart(String name, File value) throws IOException {
        this.writePartStart();
        this.mOutputStream.write(("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + value.getName() + "\"\r\n").getBytes(CHARSET));
        this.mOutputStream.write(("Content-Type: " + URLConnection.guessContentTypeFromName(value.getName()) + "\r\n").getBytes(CHARSET));
        this.mOutputStream.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes(CHARSET));
        FileInputStream inputStream = new FileInputStream(value);
        byte[] buffer = new byte[512];
        int len = 0;
        while (len != -1) {
            len = inputStream.read(buffer);
            if (len <= 0) continue;
            this.mOutputStream.write(buffer, 0, len);
        }
        inputStream.close();
        this.mOutputStream.write("\r\n".getBytes(CHARSET));
    }

    private void writePartStart() throws IOException {
        this.mOutputStream.write(("--" + this.mBoundary + "\r\n").getBytes(CHARSET));
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public boolean cancel() {
        return false;
    }
}

