/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.network;

import com.yashoid.network.OperationExecutor;

public abstract class NetworkOperation {
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_LOW = -1;
    public static final int PRIORITY_MAX = 2;
    public static final int PRIORITY_MIN = -2;
    private int mType;
    private int mPriority;
    private OperationExecutor.OperationTask mTask;

    protected NetworkOperation(int type) {
        this.mType = type;
        this.mPriority = 0;
    }

    protected NetworkOperation(int type, int priority) {
        this.mType = type;
        this.mPriority = priority;
    }

    protected final int getType() {
        return this.mType;
    }

    protected void setPriority(int priority) {
        this.mPriority = priority;
    }

    protected int getPriority() {
        return this.mPriority;
    }

    protected final void execute(OperationExecutor.OperationTask task) {
        this.mTask = task;
        this.operate();
    }

    protected abstract void operate();

    protected final void publishProgress(Object object) {
        this.mTask.publishProgress(object);
    }

    protected void onProgressUpdate(Object object) {
    }

    protected void onOperationFinished() {
    }
}

