/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.network;

import android.os.Handler;
import com.yashoid.network.NetworkOperation;
import com.yashoid.network.OperationExecutor;
import com.yashoid.network.OperationSelector;

public class NetworkOperator {
    public static final int TYPE_URGENT = 0;
    public static final int TYPE_UI_CONTENT = 1;
    public static final int TYPE_USER_ACTION = 2;
    public static final int TYPE_BACKGRUOND = 4;
    private static final int TYPE_ALL = 7;
    private static NetworkOperator mInstance = null;
    private OperationSelector mSelector;
    private Handler mHandler;
    private int mTypesInProgress = 0;
    private Object mProgressStatusLock = new Object();
    private OperationExecutor.OnExecutionFinishedListener mOnExecutionFinishedListener = new OperationExecutor.OnExecutionFinishedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExecutionFinished(NetworkOperation operation) {
            if (operation.getType() != 0) {
                Object object = NetworkOperator.this.mProgressStatusLock;
                synchronized (object) {
                    NetworkOperator.this.mTypesInProgress = NetworkOperator.this.mTypesInProgress & ~operation.getType();
                }
            }
            NetworkOperator.this.executeNextOperation();
        }
    };

    public static NetworkOperator getInstance() {
        if (mInstance == null) {
            mInstance = new NetworkOperator();
        }
        return mInstance;
    }

    private NetworkOperator() {
        this.mSelector = new OperationSelector();
        this.mHandler = new Handler();
    }

    public void post(NetworkOperation operation) {
        if (operation.getType() != 0) {
            this.mSelector.addOperation(operation);
            this.executeNextOperation();
        } else {
            this.mHandler.post((Runnable)new OperationExecutor(operation, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNextOperation() {
        Object object = this.mProgressStatusLock;
        synchronized (object) {
            if (this.mTypesInProgress == 0) {
                this.executeNextOperation(7);
            } else {
                if ((this.mTypesInProgress & 1) > 0) {
                    return;
                }
                if (this.mSelector.hasNext(1)) {
                    this.executeNextOperation(1);
                } else {
                    if ((this.mTypesInProgress & 2) > 0) {
                        return;
                    }
                    if (this.mSelector.hasNext(2)) {
                        this.executeNextOperation(2);
                    } else {
                        if ((this.mTypesInProgress & 4) > 0) {
                            return;
                        }
                        if (this.mSelector.hasNext(4)) {
                            this.executeNextOperation(4);
                        }
                    }
                }
            }
        }
    }

    private void executeNextOperation(int types) {
        NetworkOperation operation = this.mSelector.getNextOperation(types);
        if (operation != null) {
            this.mSelector.remove(operation);
            this.mTypesInProgress |= operation.getType();
            this.mHandler.post((Runnable)new OperationExecutor(operation, this.mOnExecutionFinishedListener));
        }
    }
}

