/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.network.request;

import com.yashoid.network.request.NetworkRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileRequest
extends NetworkRequest<File> {
    private static final int BUFFER_SIZE = 512;
    private File mFile;

    public FileRequest(String url, File dest) throws IOException {
        super(url);
        this.mFile = dest;
    }

    @Override
    protected File parseResponse(InputStream stream) throws IOException {
        long totalSize = this.getConnection().getContentLength();
        long currentSize = 0L;
        FileOutputStream outStream = new FileOutputStream(this.mFile);
        byte[] buffer = new byte[512];
        int len = 0;
        while (len != -1) {
            len = stream.read(buffer);
            if (len <= 0) continue;
            outStream.write(buffer, 0, len);
            this.onDownloadProgressChanged(currentSize += (long)len, totalSize);
        }
        outStream.close();
        return this.mFile;
    }

    protected void onDownloadProgressChanged(long current, long total) {
    }
}

