/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.network.request;

import com.yashoid.network.request.NetworkRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MultipartBody
implements NetworkRequest.BodyLoader {
    private static final String BOUNDARY_WRAPPER = "===";
    private static final String CONTENT_TYPE = "multipart/form-data; boundary=";
    private static final String CHARSET = "UTF-8";
    private static final String STRING_PART_CONTENT_TYPE = "Content-Type: text/plain; charset=UTF-8\r\n";
    private HttpURLConnection mConnection;
    private OutputStream mOutputStream;
    private String mBoundary;
    private HashMap<String, ArrayList<Object>> mParts;

    public MultipartBody(HttpURLConnection connection) {
        this.mConnection = connection;
        this.mBoundary = BOUNDARY_WRAPPER + System.currentTimeMillis() + BOUNDARY_WRAPPER;
        this.mParts = new HashMap(10);
        this.mConnection.setUseCaches(false);
        this.mConnection.setRequestProperty("Content-Type", this.getContentType());
    }

    public MultipartBody(NetworkRequest<?> request) {
        this(request.getConnection());
    }

    private String getContentType() {
        return CONTENT_TYPE + this.mBoundary;
    }

    public void addPart(String name, String value) {
        this.putPart(name, value);
    }

    public void addPart(String name, File value) {
        this.putPart(name, value);
    }

    public void addPart(String name, String fileName, InputStream value) {
        this.putPart(name, new InputStreamValue(fileName, value, 0L));
    }

    public void addPart(String name, String fileName, InputStream value, long length) {
        this.putPart(name, new InputStreamValue(fileName, value, length));
    }

    private void putPart(String name, Object value) {
        ArrayList<Object> values = this.mParts.get(name);
        if (values == null) {
            values = new ArrayList(4);
            this.mParts.put(name, values);
        }
        values.add(value);
    }

    @Override
    public void write(OutputStream output) throws IOException {
        this.mOutputStream = output;
        for (Map.Entry<String, ArrayList<Object>> part : this.mParts.entrySet()) {
            String name = part.getKey();
            ArrayList<Object> values = part.getValue();
            for (Object value : values) {
                this.onStartedWritingPart(name);
                if (value instanceof String) {
                    this.writeStringPart(name, (String)value);
                } else if (value instanceof File) {
                    this.writeFilePart(name, (File)value);
                } else if (value instanceof InputStreamValue) {
                    this.writeInputStreamPart(name, (InputStreamValue)value);
                }
                this.mOutputStream.flush();
                this.onFinishedWritingPart(name);
            }
        }
        this.mOutputStream.write(("--" + this.mBoundary + "--\r\n").getBytes(CHARSET));
    }

    private void writeStringPart(String name, String value) throws IOException {
        this.writePartStart();
        this.mOutputStream.write(("Content-Disposition: form-data; name=\"" + name + "\"\r\n").getBytes(CHARSET));
        this.mOutputStream.write(STRING_PART_CONTENT_TYPE.getBytes(CHARSET));
        this.mOutputStream.write(("\r\n" + value + "\r\n").getBytes(CHARSET));
    }

    private void writeFilePart(String name, File value) throws IOException {
        this.writeInputStreamPart(name, value.getName(), new FileInputStream(value), value.length());
    }

    private void writeInputStreamPart(String name, InputStreamValue value) throws IOException {
        this.writeInputStreamPart(name, value.fileName, value.stream, value.length);
    }

    private void writeInputStreamPart(String name, String fileName, InputStream inputStream, long total) throws IOException {
        this.writePartStart();
        this.mOutputStream.write(("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"\r\n").getBytes(CHARSET));
        this.mOutputStream.write(("Content-Type: " + URLConnection.guessContentTypeFromName(fileName) + "\r\n").getBytes(CHARSET));
        this.mOutputStream.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes(CHARSET));
        byte[] buffer = new byte[1024];
        int len = 0;
        long progress = 0L;
        while (len != -1) {
            len = inputStream.read(buffer);
            if (len <= 0) continue;
            this.mOutputStream.write(buffer, 0, len);
            this.mOutputStream.flush();
            this.onWritingPartProgress(name, progress += (long)len, total);
        }
        inputStream.close();
        this.mOutputStream.write("\r\n".getBytes(CHARSET));
    }

    private void writePartStart() throws IOException {
        this.mOutputStream.write(("--" + this.mBoundary + "\r\n").getBytes(CHARSET));
    }

    protected void onStartedWritingPart(String name) {
    }

    protected void onWritingPartProgress(String name, long progress, long total) {
    }

    protected void onFinishedWritingPart(String name) {
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public boolean cancel() {
        return false;
    }

    private static class InputStreamValue {
        private String fileName;
        private InputStream stream;
        private long length;

        protected InputStreamValue(String fileName, InputStream stream, long length) {
            this.fileName = fileName;
            this.stream = stream;
            this.length = length;
        }
    }
}

