/*
 * Decompiled with CFR 0.152.
 */
package com.yashoid.network.request;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class NetworkRequest<Return> {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final int NO_RESPONSE_CODE = -1;
    private URL mURL;
    private HttpURLConnection mConnection;
    Map<String, List<String>> mRequestProperties;
    private BodyLoader mBodyLoader = null;
    private boolean mIsExecuted = false;
    private boolean mIsCanceled = false;
    private int mResponseCode = -1;

    public NetworkRequest(String url) throws IOException {
        this.mURL = new URL(url);
        this.mConnection = (HttpURLConnection)this.mURL.openConnection();
        this.mConnection.setDoInput(true);
    }

    public void resetRequest() throws IOException {
        try {
            this.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String method = this.mConnection.getRequestMethod();
        this.mURL = new URL(this.mURL.toExternalForm());
        this.mConnection = (HttpURLConnection)this.mURL.openConnection();
        this.mConnection.setDoInput(true);
        for (String headerName : this.mRequestProperties.keySet()) {
            List<String> headerValues = this.mRequestProperties.get(headerName);
            for (String headerValue : headerValues) {
                this.mConnection.addRequestProperty(headerName, headerValue);
            }
        }
        this.setMethod(method);
    }

    public HttpURLConnection getConnection() {
        return this.mConnection;
    }

    public boolean setMethod(String method) {
        try {
            this.mConnection.setRequestMethod(method);
        }
        catch (ProtocolException exception) {
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(this.mConnection);
            try {
                Field field = HttpURLConnection.class.getDeclaredField("method");
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                field.set(connection, method);
                field.setAccessible(isAccessible);
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    public void setBody(String body) {
        this.mBodyLoader = new StringBodyLoader(body);
    }

    public void setBody(JSONObject body) {
        this.mBodyLoader = new StringBodyLoader(body.toString());
        this.getConnection().setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_JSON);
    }

    public void setBody(JSONArray body) {
        this.mBodyLoader = new StringBodyLoader(body.toString());
        this.getConnection().setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_JSON);
    }

    public void setBody(InputStream stream) {
        this.mBodyLoader = new InputStreamBodyLoader(stream);
    }

    public void setBody(File file) {
        this.mBodyLoader = new FileBodyLoader(file);
    }

    public void setBody(BodyLoader bodyLoader) {
        this.mBodyLoader = bodyLoader;
    }

    public Return execute() throws IOException {
        this.mRequestProperties = this.mConnection.getRequestProperties();
        IOException exception = null;
        try {
            if (this.mBodyLoader != null) {
                this.mConnection.setDoOutput(true);
                this.mBodyLoader.write(this.mConnection.getOutputStream());
                if (this.mIsCanceled) {
                    this.disconnect();
                    return null;
                }
            }
            this.mIsExecuted = true;
            this.mResponseCode = this.mConnection.getResponseCode();
            InputStream stream = this.mConnection.getErrorStream();
            if (stream == null) {
                stream = this.mConnection.getInputStream();
            }
            return this.parseResponse(stream);
        }
        catch (IOException e) {
            exception = e;
            if (exception != null) {
                this.mConnection.disconnect();
            }
            throw exception;
        }
    }

    protected abstract Return parseResponse(InputStream var1) throws IOException;

    protected void disconnect() {
        this.mConnection.disconnect();
    }

    public boolean isCancelable() {
        return this.mBodyLoader == null ? false : this.mBodyLoader.isCancelable();
    }

    public boolean cancel() {
        if (!this.isCancelable()) {
            return false;
        }
        if (this.mIsExecuted) {
            return false;
        }
        this.mIsCanceled = this.mBodyLoader.cancel();
        return this.mIsCanceled;
    }

    public boolean isCanceled() {
        return this.mIsCanceled;
    }

    public boolean isExecuted() {
        return this.mIsExecuted;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public static String toString(InputStream input, String charsetName) throws IOException {
        ByteArrayOutputStream stringBuilder = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[256];
        while (len != -1) {
            len = input.read(buffer);
            if (len <= 0) continue;
            stringBuilder.write(buffer, 0, len);
        }
        return stringBuilder.toString(charsetName);
    }

    private static class FileBodyLoader
    implements BodyLoader {
        private File mFile;
        private boolean mIsCanceled = false;
        private boolean mIsFinished = false;

        protected FileBodyLoader(File file) {
            this.mFile = file;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            FileInputStream input = new FileInputStream(this.mFile);
            int len = 0;
            byte[] buffer = new byte[256];
            while (len != -1 && !this.mIsCanceled) {
                len = input.read(buffer);
                if (len <= 0 || this.mIsCanceled) continue;
                output.write(buffer, 0, len);
                output.flush();
            }
            input.close();
            this.mIsFinished = true;
        }

        @Override
        public boolean isCancelable() {
            return true;
        }

        @Override
        public boolean cancel() {
            if (this.mIsFinished) {
                return this.mIsCanceled;
            }
            this.mIsCanceled = true;
            return true;
        }
    }

    protected static class InputStreamBodyLoader
    implements BodyLoader {
        private InputStream mStream;
        private boolean mIsCanceled = false;
        private boolean mIsFinished = false;

        protected InputStreamBodyLoader(InputStream stream) {
            this.mStream = stream;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            int len = 0;
            byte[] buffer = new byte[256];
            while (len != -1 && !this.mIsCanceled) {
                len = this.mStream.read(buffer);
                if (len <= 0 || this.mIsCanceled) continue;
                output.write(buffer, 0, len);
                output.flush();
            }
            this.mIsFinished = true;
        }

        @Override
        public boolean isCancelable() {
            return true;
        }

        @Override
        public boolean cancel() {
            if (this.mIsFinished) {
                return this.mIsCanceled;
            }
            this.mIsCanceled = true;
            return true;
        }
    }

    private static class StringBodyLoader
    implements BodyLoader {
        private String mBody;

        protected StringBodyLoader(String body) {
            this.mBody = body;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            output.write(this.mBody.getBytes());
        }

        @Override
        public boolean isCancelable() {
            return false;
        }

        @Override
        public boolean cancel() {
            return false;
        }
    }

    protected static interface BodyLoader {
        public void write(OutputStream var1) throws IOException;

        public boolean isCancelable();

        public boolean cancel();
    }
}

