/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.yayandroid.locationmanager.configuration.LocationConfiguration;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.helper.logging.Logger;
import com.yayandroid.locationmanager.listener.LocationListener;
import com.yayandroid.locationmanager.listener.PermissionListener;
import com.yayandroid.locationmanager.providers.locationprovider.DispatcherLocationProvider;
import com.yayandroid.locationmanager.providers.locationprovider.LocationProvider;
import com.yayandroid.locationmanager.providers.permissionprovider.PermissionProvider;
import com.yayandroid.locationmanager.view.ContextProcessor;

public class LocationManager
implements PermissionListener {
    private LocationListener listener;
    private LocationConfiguration configuration;
    private LocationProvider activeProvider;
    private PermissionProvider permissionProvider;

    public static void enableLog(boolean enable) {
        LogUtils.enable(enable);
    }

    public static void setLogger(@NonNull Logger logger) {
        LogUtils.setLogger(logger);
    }

    private LocationManager(Builder builder) {
        this.listener = builder.listener;
        this.configuration = builder.configuration;
        this.activeProvider = builder.activeProvider;
        this.permissionProvider = this.getConfiguration().permissionConfiguration().permissionProvider();
        this.permissionProvider.setContextProcessor(builder.contextProcessor);
        this.permissionProvider.setPermissionListener(this);
    }

    public LocationConfiguration getConfiguration() {
        return this.configuration;
    }

    public void onPause() {
        this.activeProvider.onPause();
    }

    public void onResume() {
        this.activeProvider.onResume();
    }

    public void onDestroy() {
        this.activeProvider.onDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.activeProvider.onActivityResult(requestCode, resultCode, data);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.permissionProvider.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public boolean isWaitingForLocation() {
        return this.activeProvider.isWaiting();
    }

    public boolean isAnyDialogShowing() {
        return this.activeProvider.isDialogShowing();
    }

    public void cancel() {
        this.activeProvider.cancel();
    }

    public void get() {
        this.askForPermission();
    }

    LocationProvider activeProvider() {
        return this.activeProvider;
    }

    void askForPermission() {
        if (this.permissionProvider.hasPermission()) {
            this.permissionGranted(true);
        } else {
            if (this.listener != null) {
                this.listener.onProcessTypeChanged(1);
            }
            if (this.permissionProvider.requestPermissions()) {
                LogUtils.logI("Waiting until we receive any callback from PermissionProvider...");
            } else {
                LogUtils.logI("Couldn't get permission, Abort!");
                this.failed(2);
            }
        }
    }

    private void permissionGranted(boolean alreadyHadPermission) {
        LogUtils.logI("We got permission!");
        if (this.listener != null) {
            this.listener.onPermissionGranted(alreadyHadPermission);
        }
        this.activeProvider.get();
    }

    private void failed(int type) {
        if (this.listener != null) {
            this.listener.onLocationFailed(type);
        }
    }

    @Override
    public void onPermissionsGranted() {
        this.permissionGranted(false);
    }

    @Override
    public void onPermissionsDenied() {
        this.failed(2);
    }

    public static class Builder {
        private ContextProcessor contextProcessor;
        private LocationListener listener;
        private LocationConfiguration configuration;
        private LocationProvider activeProvider;

        public Builder(@NonNull ContextProcessor contextProcessor) {
            this.contextProcessor = contextProcessor;
        }

        public Builder(@NonNull Context context) {
            this.contextProcessor = new ContextProcessor(context);
        }

        public Builder activity(Activity activity) {
            this.contextProcessor.setActivity(activity);
            return this;
        }

        public Builder fragment(Fragment fragment) {
            this.contextProcessor.setFragment(fragment);
            return this;
        }

        public Builder configuration(@NonNull LocationConfiguration locationConfiguration) {
            this.configuration = locationConfiguration;
            return this;
        }

        public Builder locationProvider(@NonNull LocationProvider provider) {
            this.activeProvider = provider;
            return this;
        }

        public Builder notify(LocationListener listener) {
            this.listener = listener;
            return this;
        }

        public LocationManager build() {
            if (this.contextProcessor == null) {
                throw new IllegalStateException("You must set a context to LocationManager.");
            }
            if (this.configuration == null) {
                throw new IllegalStateException("You must set a configuration object.");
            }
            if (this.activeProvider == null) {
                this.locationProvider(new DispatcherLocationProvider());
            }
            this.activeProvider.configure(this.contextProcessor, this.configuration, this.listener);
            return new LocationManager(this);
        }
    }
}

