/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.base;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.yayandroid.locationmanager.LocationManager;
import com.yayandroid.locationmanager.configuration.LocationConfiguration;
import com.yayandroid.locationmanager.listener.LocationListener;

public abstract class LocationBaseActivity
extends AppCompatActivity
implements LocationListener {
    private LocationManager locationManager;

    public abstract LocationConfiguration getLocationConfiguration();

    protected LocationManager getLocationManager() {
        return this.locationManager;
    }

    protected void getLocation() {
        if (this.locationManager == null) {
            throw new IllegalStateException("locationManager is null. Make sure you call super.initialize before attempting to getLocation");
        }
        this.locationManager.get();
    }

    @CallSuper
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.locationManager = new LocationManager.Builder(this.getApplicationContext()).configuration(this.getLocationConfiguration()).activity((Activity)this).notify(this).build();
    }

    @CallSuper
    protected void onDestroy() {
        this.locationManager.onDestroy();
        super.onDestroy();
    }

    @CallSuper
    protected void onPause() {
        this.locationManager.onPause();
        super.onPause();
    }

    @CallSuper
    protected void onResume() {
        super.onResume();
        this.locationManager.onResume();
    }

    @CallSuper
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.locationManager.onActivityResult(requestCode, resultCode, data);
    }

    @CallSuper
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.locationManager.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onProcessTypeChanged(int processType) {
    }

    @Override
    public void onPermissionGranted(boolean alreadyHadPermission) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }
}

