/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.base;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.yayandroid.locationmanager.LocationManager;
import com.yayandroid.locationmanager.configuration.LocationConfiguration;
import com.yayandroid.locationmanager.listener.LocationListener;

public abstract class LocationBaseFragment
extends Fragment
implements LocationListener {
    private LocationManager locationManager;

    public abstract LocationConfiguration getLocationConfiguration();

    protected LocationManager getLocationManager() {
        return this.locationManager;
    }

    protected void getLocation() {
        if (this.locationManager == null) {
            throw new IllegalStateException("locationManager is null. Make sure you call super.initialize before attempting to getLocation");
        }
        this.locationManager.get();
    }

    @CallSuper
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.locationManager = new LocationManager.Builder(this.getContext().getApplicationContext()).configuration(this.getLocationConfiguration()).fragment(this).notify(this).build();
    }

    @CallSuper
    public void onDestroy() {
        this.locationManager.onDestroy();
        super.onDestroy();
    }

    @CallSuper
    public void onPause() {
        this.locationManager.onPause();
        super.onPause();
    }

    @CallSuper
    public void onResume() {
        super.onResume();
        this.locationManager.onResume();
    }

    @CallSuper
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.locationManager.onActivityResult(requestCode, resultCode, data);
    }

    @CallSuper
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.locationManager.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onProcessTypeChanged(int processType) {
    }

    @Override
    public void onPermissionGranted(boolean alreadyHadPermission) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }
}

