/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.configuration;

import androidx.annotation.NonNull;
import com.yayandroid.locationmanager.configuration.DefaultProviderConfiguration;
import com.yayandroid.locationmanager.configuration.GooglePlayServicesConfiguration;
import com.yayandroid.locationmanager.configuration.LocationConfiguration;
import com.yayandroid.locationmanager.configuration.PermissionConfiguration;

public final class Configurations {
    private Configurations() {
    }

    public static LocationConfiguration silentConfiguration() {
        return Configurations.silentConfiguration(true);
    }

    public static LocationConfiguration silentConfiguration(boolean keepTracking) {
        return new LocationConfiguration.Builder().keepTracking(keepTracking).useGooglePlayServices(new GooglePlayServicesConfiguration.Builder().askForSettingsApi(false).build()).useDefaultProviders(new DefaultProviderConfiguration.Builder().build()).build();
    }

    public static LocationConfiguration defaultConfiguration(@NonNull String rationalMessage, @NonNull String gpsMessage) {
        return new LocationConfiguration.Builder().askForPermission(new PermissionConfiguration.Builder().rationaleMessage(rationalMessage).build()).useGooglePlayServices(new GooglePlayServicesConfiguration.Builder().build()).useDefaultProviders(new DefaultProviderConfiguration.Builder().gpsMessage(gpsMessage).build()).build();
    }
}

