/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.configuration;

import androidx.annotation.Nullable;
import com.yayandroid.locationmanager.helper.StringUtils;
import com.yayandroid.locationmanager.providers.dialogprovider.DialogProvider;
import com.yayandroid.locationmanager.providers.dialogprovider.SimpleMessageDialogProvider;

public class DefaultProviderConfiguration {
    private final long requiredTimeInterval;
    private final long requiredDistanceInterval;
    private final float acceptableAccuracy;
    private final long acceptableTimePeriod;
    private final long gpsWaitPeriod;
    private final long networkWaitPeriod;
    private final DialogProvider gpsDialogProvider;

    private DefaultProviderConfiguration(Builder builder) {
        this.requiredTimeInterval = builder.requiredTimeInterval;
        this.requiredDistanceInterval = builder.requiredDistanceInterval;
        this.acceptableAccuracy = builder.acceptableAccuracy;
        this.acceptableTimePeriod = builder.acceptableTimePeriod;
        this.gpsWaitPeriod = builder.gpsWaitPeriod;
        this.networkWaitPeriod = builder.networkWaitPeriod;
        this.gpsDialogProvider = builder.gpsDialogProvider;
    }

    public Builder newBuilder() {
        return new Builder().requiredTimeInterval(this.requiredTimeInterval).requiredDistanceInterval(this.requiredDistanceInterval).acceptableAccuracy(this.acceptableAccuracy).acceptableTimePeriod(this.acceptableTimePeriod).setWaitPeriod(2, this.gpsWaitPeriod).setWaitPeriod(3, this.networkWaitPeriod).gpsDialogProvider(this.gpsDialogProvider);
    }

    public long requiredTimeInterval() {
        return this.requiredTimeInterval;
    }

    public long requiredDistanceInterval() {
        return this.requiredDistanceInterval;
    }

    public float acceptableAccuracy() {
        return this.acceptableAccuracy;
    }

    public long acceptableTimePeriod() {
        return this.acceptableTimePeriod;
    }

    public boolean askForEnableGPS() {
        return this.gpsDialogProvider != null;
    }

    @Nullable
    public DialogProvider gpsDialogProvider() {
        return this.gpsDialogProvider;
    }

    public long gpsWaitPeriod() {
        return this.gpsWaitPeriod;
    }

    public long networkWaitPeriod() {
        return this.networkWaitPeriod;
    }

    public static class Builder {
        private long requiredTimeInterval = 300000L;
        private long requiredDistanceInterval = 0L;
        private float acceptableAccuracy = 5.0f;
        private long acceptableTimePeriod = 300000L;
        private long gpsWaitPeriod = 20000L;
        private long networkWaitPeriod = 20000L;
        private DialogProvider gpsDialogProvider;
        private String gpsMessage = "";

        public Builder requiredTimeInterval(long requiredTimeInterval) {
            if (requiredTimeInterval < 0L) {
                throw new IllegalArgumentException("requiredTimeInterval cannot be set to negative value.");
            }
            this.requiredTimeInterval = requiredTimeInterval;
            return this;
        }

        public Builder requiredDistanceInterval(long requiredDistanceInterval) {
            if (requiredDistanceInterval < 0L) {
                throw new IllegalArgumentException("requiredDistanceInterval cannot be set to negative value.");
            }
            this.requiredDistanceInterval = requiredDistanceInterval;
            return this;
        }

        public Builder acceptableAccuracy(float acceptableAccuracy) {
            if (acceptableAccuracy < 0.0f) {
                throw new IllegalArgumentException("acceptableAccuracy cannot be set to negative value.");
            }
            this.acceptableAccuracy = acceptableAccuracy;
            return this;
        }

        public Builder acceptableTimePeriod(long acceptableTimePeriod) {
            if (acceptableTimePeriod < 0L) {
                throw new IllegalArgumentException("acceptableTimePeriod cannot be set to negative value.");
            }
            this.acceptableTimePeriod = acceptableTimePeriod;
            return this;
        }

        public Builder gpsMessage(String gpsMessage) {
            this.gpsMessage = gpsMessage;
            return this;
        }

        public Builder gpsDialogProvider(DialogProvider dialogProvider) {
            this.gpsDialogProvider = dialogProvider;
            return this;
        }

        public Builder setWaitPeriod(int providerType, long milliseconds) {
            if (milliseconds < 0L) {
                throw new IllegalArgumentException("waitPeriod cannot be set to negative value.");
            }
            switch (providerType) {
                case 1: {
                    throw new IllegalStateException("GooglePlayServices waiting time period should be set on GooglePlayServicesConfiguration");
                }
                case 3: {
                    this.networkWaitPeriod = milliseconds;
                    break;
                }
                case 2: {
                    this.gpsWaitPeriod = milliseconds;
                    break;
                }
                case 4: {
                    this.gpsWaitPeriod = milliseconds;
                    this.networkWaitPeriod = milliseconds;
                    break;
                }
            }
            return this;
        }

        public DefaultProviderConfiguration build() {
            if (this.gpsDialogProvider == null && StringUtils.isNotEmpty(this.gpsMessage)) {
                this.gpsDialogProvider = new SimpleMessageDialogProvider(this.gpsMessage);
            }
            return new DefaultProviderConfiguration(this);
        }
    }
}

