/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.configuration;

import androidx.annotation.NonNull;
import com.google.android.gms.location.LocationRequest;
import com.yayandroid.locationmanager.configuration.Defaults;

public class GooglePlayServicesConfiguration {
    private final LocationRequest locationRequest;
    private final boolean fallbackToDefault;
    private final boolean askForGooglePlayServices;
    private final boolean askForSettingsApi;
    private final boolean failOnSettingsApiSuspended;
    private final boolean ignoreLastKnowLocation;
    private final long googlePlayServicesWaitPeriod;

    private GooglePlayServicesConfiguration(Builder builder) {
        this.locationRequest = builder.locationRequest;
        this.fallbackToDefault = builder.fallbackToDefault;
        this.askForGooglePlayServices = builder.askForGooglePlayServices;
        this.askForSettingsApi = builder.askForSettingsApi;
        this.failOnSettingsApiSuspended = builder.failOnSettingsApiSuspended;
        this.ignoreLastKnowLocation = builder.ignoreLastKnowLocation;
        this.googlePlayServicesWaitPeriod = builder.googlePlayServicesWaitPeriod;
    }

    public Builder newBuilder() {
        return new Builder().locationRequest(this.locationRequest).fallbackToDefault(this.fallbackToDefault).askForGooglePlayServices(this.askForGooglePlayServices).askForSettingsApi(this.askForSettingsApi).failOnSettingsApiSuspended(this.failOnSettingsApiSuspended).ignoreLastKnowLocation(this.ignoreLastKnowLocation).setWaitPeriod(this.googlePlayServicesWaitPeriod);
    }

    public LocationRequest locationRequest() {
        return this.locationRequest;
    }

    public boolean fallbackToDefault() {
        return this.fallbackToDefault;
    }

    public boolean askForGooglePlayServices() {
        return this.askForGooglePlayServices;
    }

    public boolean askForSettingsApi() {
        return this.askForSettingsApi;
    }

    public boolean failOnSettingsApiSuspended() {
        return this.failOnSettingsApiSuspended;
    }

    public boolean ignoreLastKnowLocation() {
        return this.ignoreLastKnowLocation;
    }

    public long googlePlayServicesWaitPeriod() {
        return this.googlePlayServicesWaitPeriod;
    }

    public static class Builder {
        private LocationRequest locationRequest = Defaults.createDefaultLocationRequest();
        private boolean fallbackToDefault = true;
        private boolean askForGooglePlayServices = false;
        private boolean askForSettingsApi = true;
        private boolean failOnSettingsApiSuspended = false;
        private boolean ignoreLastKnowLocation = false;
        private long googlePlayServicesWaitPeriod = 20000L;

        public Builder locationRequest(@NonNull LocationRequest locationRequest) {
            this.locationRequest = locationRequest;
            return this;
        }

        public Builder fallbackToDefault(boolean fallbackToDefault) {
            this.fallbackToDefault = fallbackToDefault;
            return this;
        }

        public Builder askForGooglePlayServices(boolean askForGooglePlayServices) {
            this.askForGooglePlayServices = askForGooglePlayServices;
            return this;
        }

        public Builder askForSettingsApi(boolean askForSettingsApi) {
            this.askForSettingsApi = askForSettingsApi;
            return this;
        }

        public Builder failOnSettingsApiSuspended(boolean failOnSettingsApiSuspended) {
            this.failOnSettingsApiSuspended = failOnSettingsApiSuspended;
            return this;
        }

        public Builder ignoreLastKnowLocation(boolean ignore) {
            this.ignoreLastKnowLocation = ignore;
            return this;
        }

        public Builder setWaitPeriod(long milliseconds) {
            if (milliseconds < 0L) {
                throw new IllegalArgumentException("waitPeriod cannot be set to negative value.");
            }
            this.googlePlayServicesWaitPeriod = milliseconds;
            return this;
        }

        public GooglePlayServicesConfiguration build() {
            return new GooglePlayServicesConfiguration(this);
        }
    }
}

