/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.configuration;

import androidx.annotation.Nullable;
import com.yayandroid.locationmanager.configuration.DefaultProviderConfiguration;
import com.yayandroid.locationmanager.configuration.GooglePlayServicesConfiguration;
import com.yayandroid.locationmanager.configuration.PermissionConfiguration;
import com.yayandroid.locationmanager.providers.permissionprovider.StubPermissionProvider;

public class LocationConfiguration {
    private final boolean keepTracking;
    private final PermissionConfiguration permissionConfiguration;
    private final GooglePlayServicesConfiguration googlePlayServicesConfiguration;
    private final DefaultProviderConfiguration defaultProviderConfiguration;

    private LocationConfiguration(Builder builder) {
        this.keepTracking = builder.keepTracking;
        this.permissionConfiguration = builder.permissionConfiguration;
        this.googlePlayServicesConfiguration = builder.googlePlayServicesConfiguration;
        this.defaultProviderConfiguration = builder.defaultProviderConfiguration;
    }

    public Builder newBuilder() {
        return new Builder().keepTracking(this.keepTracking).askForPermission(this.permissionConfiguration).useGooglePlayServices(this.googlePlayServicesConfiguration).useDefaultProviders(this.defaultProviderConfiguration);
    }

    public boolean keepTracking() {
        return this.keepTracking;
    }

    public PermissionConfiguration permissionConfiguration() {
        return this.permissionConfiguration;
    }

    @Nullable
    public GooglePlayServicesConfiguration googlePlayServicesConfiguration() {
        return this.googlePlayServicesConfiguration;
    }

    @Nullable
    public DefaultProviderConfiguration defaultProviderConfiguration() {
        return this.defaultProviderConfiguration;
    }

    public static class Builder {
        private boolean keepTracking = false;
        private PermissionConfiguration permissionConfiguration;
        private GooglePlayServicesConfiguration googlePlayServicesConfiguration;
        private DefaultProviderConfiguration defaultProviderConfiguration;

        public Builder keepTracking(boolean keepTracking) {
            this.keepTracking = keepTracking;
            return this;
        }

        public Builder askForPermission(PermissionConfiguration permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration;
            return this;
        }

        public Builder useGooglePlayServices(GooglePlayServicesConfiguration googlePlayServicesConfiguration) {
            this.googlePlayServicesConfiguration = googlePlayServicesConfiguration;
            return this;
        }

        public Builder useDefaultProviders(DefaultProviderConfiguration defaultProviderConfiguration) {
            this.defaultProviderConfiguration = defaultProviderConfiguration;
            return this;
        }

        public LocationConfiguration build() {
            if (this.googlePlayServicesConfiguration == null && this.defaultProviderConfiguration == null) {
                throw new IllegalStateException("You need to specify one of the provider configurations. Please see GooglePlayServicesConfiguration and DefaultProviderConfiguration");
            }
            if (this.permissionConfiguration == null) {
                this.permissionConfiguration = new PermissionConfiguration.Builder().permissionProvider(new StubPermissionProvider()).build();
            }
            return new LocationConfiguration(this);
        }
    }
}

