/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.configuration;

import com.yayandroid.locationmanager.configuration.Defaults;
import com.yayandroid.locationmanager.helper.StringUtils;
import com.yayandroid.locationmanager.providers.dialogprovider.DialogProvider;
import com.yayandroid.locationmanager.providers.dialogprovider.SimpleMessageDialogProvider;
import com.yayandroid.locationmanager.providers.permissionprovider.DefaultPermissionProvider;
import com.yayandroid.locationmanager.providers.permissionprovider.PermissionProvider;

public class PermissionConfiguration {
    private final PermissionProvider permissionProvider;

    private PermissionConfiguration(Builder builder) {
        this.permissionProvider = builder.permissionProvider;
    }

    public PermissionProvider permissionProvider() {
        return this.permissionProvider;
    }

    public static class Builder {
        private String rationaleMessage = "";
        private String[] requiredPermissions = Defaults.LOCATION_PERMISSIONS;
        private DialogProvider rationaleDialogProvider;
        private PermissionProvider permissionProvider;

        public Builder rationaleMessage(String rationaleMessage) {
            this.rationaleMessage = rationaleMessage;
            return this;
        }

        public Builder requiredPermissions(String[] permissions) {
            if (permissions == null || permissions.length == 0) {
                throw new IllegalArgumentException("requiredPermissions cannot be empty.");
            }
            this.requiredPermissions = permissions;
            return this;
        }

        public Builder rationaleDialogProvider(DialogProvider dialogProvider) {
            this.rationaleDialogProvider = dialogProvider;
            return this;
        }

        public Builder permissionProvider(PermissionProvider permissionProvider) {
            this.permissionProvider = permissionProvider;
            return this;
        }

        public PermissionConfiguration build() {
            if (this.rationaleDialogProvider == null && StringUtils.isNotEmpty(this.rationaleMessage)) {
                this.rationaleDialogProvider = new SimpleMessageDialogProvider(this.rationaleMessage);
            }
            if (this.permissionProvider == null) {
                this.permissionProvider = new DefaultPermissionProvider(this.requiredPermissions, this.rationaleDialogProvider);
            }
            return new PermissionConfiguration(this);
        }
    }
}

