/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.helper;

import androidx.annotation.NonNull;
import com.yayandroid.locationmanager.helper.logging.DefaultLogger;
import com.yayandroid.locationmanager.helper.logging.Logger;

public final class LogUtils {
    private static boolean isEnabled = false;
    private static Logger activeLogger = new DefaultLogger();

    private LogUtils() {
    }

    public static void enable(boolean isEnabled) {
        LogUtils.isEnabled = isEnabled;
    }

    public static void setLogger(@NonNull Logger logger) {
        activeLogger = logger;
    }

    public static void logD(String message) {
        if (isEnabled) {
            activeLogger.logD(LogUtils.getClassName(), message);
        }
    }

    public static void logE(String message) {
        if (isEnabled) {
            activeLogger.logE(LogUtils.getClassName(), message);
        }
    }

    public static void logI(String message) {
        if (isEnabled) {
            activeLogger.logI(LogUtils.getClassName(), message);
        }
    }

    public static void logV(String message) {
        if (isEnabled) {
            activeLogger.logV(LogUtils.getClassName(), message);
        }
    }

    public static void logW(String message) {
        if (isEnabled) {
            activeLogger.logW(LogUtils.getClassName(), message);
        }
    }

    private static String getClassName() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement relevantTrace = trace[4];
        String className = relevantTrace.getClassName();
        int lastIndex = className.lastIndexOf(46);
        return className.substring(lastIndex + 1);
    }
}

