/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.helper;

import android.location.LocationListener;
import android.location.LocationManager;
import com.yayandroid.locationmanager.helper.StringUtils;

public class UpdateRequest {
    private final LocationManager locationManager;
    private final LocationListener locationListener;
    private String provider;
    private long minTime;
    private float minDistance;

    public UpdateRequest(LocationManager locationManager, LocationListener locationListener) {
        this.locationManager = locationManager;
        this.locationListener = locationListener;
    }

    public void run(String provider, long minTime, float minDistance) {
        this.provider = provider;
        this.minTime = minTime;
        this.minDistance = minDistance;
        this.run();
    }

    public void run() {
        if (StringUtils.isNotEmpty(this.provider)) {
            this.locationManager.requestLocationUpdates(this.provider, this.minTime, this.minDistance, this.locationListener);
        }
    }

    public void release() {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates(this.locationListener);
        }
    }
}

