/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.helper.continuoustask;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.yayandroid.locationmanager.helper.continuoustask.ContinuousTaskScheduler;

public class ContinuousTask
extends Handler
implements Runnable {
    private final String taskId;
    private final ContinuousTaskScheduler continuousTaskScheduler;
    private final ContinuousTaskRunner continuousTaskRunner;

    public ContinuousTask(@NonNull String taskId, @NonNull ContinuousTaskRunner continuousTaskRunner) {
        this.taskId = taskId;
        this.continuousTaskScheduler = new ContinuousTaskScheduler(this);
        this.continuousTaskRunner = continuousTaskRunner;
    }

    public void delayed(long delay) {
        this.continuousTaskScheduler.delayed(delay);
    }

    public void pause() {
        this.continuousTaskScheduler.onPause();
    }

    public void resume() {
        this.continuousTaskScheduler.onResume();
    }

    public void stop() {
        this.continuousTaskScheduler.onStop();
    }

    @Override
    public void run() {
        this.continuousTaskRunner.runScheduledTask(this.taskId);
    }

    void schedule(long delay) {
        this.postDelayed(this, delay);
    }

    void unregister() {
        this.removeCallbacks(this);
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static interface ContinuousTaskRunner {
        public void runScheduledTask(@NonNull String var1);
    }
}

