/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.helper.continuoustask;

import com.yayandroid.locationmanager.helper.continuoustask.ContinuousTask;

class ContinuousTaskScheduler {
    private static final long NONE = Long.MIN_VALUE;
    private final ContinuousTask task;
    private long requiredDelay = Long.MIN_VALUE;
    private long initialTime = Long.MIN_VALUE;
    private long remainingTime = Long.MIN_VALUE;
    private boolean isSet = false;

    ContinuousTaskScheduler(ContinuousTask task) {
        this.task = task;
    }

    boolean isSet() {
        return this.isSet;
    }

    void delayed(long delay) {
        this.remainingTime = this.requiredDelay = delay;
        this.initialTime = this.task.getCurrentTime();
        this.set(delay);
    }

    void onPause() {
        if (this.requiredDelay != Long.MIN_VALUE) {
            this.release();
            this.remainingTime = this.requiredDelay - (this.task.getCurrentTime() - this.initialTime);
        }
    }

    void onResume() {
        if (this.remainingTime != Long.MIN_VALUE) {
            this.set(this.remainingTime);
        }
    }

    void onStop() {
        this.release();
        this.clean();
    }

    void set(long delay) {
        if (!this.isSet) {
            this.task.schedule(delay);
            this.isSet = true;
        }
    }

    void release() {
        this.task.unregister();
        this.isSet = false;
    }

    void clean() {
        this.requiredDelay = Long.MIN_VALUE;
        this.initialTime = Long.MIN_VALUE;
        this.remainingTime = Long.MIN_VALUE;
        this.isSet = false;
    }
}

