/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.locationprovider;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.helper.continuoustask.ContinuousTask;
import com.yayandroid.locationmanager.listener.DialogListener;
import com.yayandroid.locationmanager.providers.dialogprovider.DialogProvider;
import com.yayandroid.locationmanager.providers.locationprovider.DefaultLocationSource;
import com.yayandroid.locationmanager.providers.locationprovider.LocationProvider;

public class DefaultLocationProvider
extends LocationProvider
implements ContinuousTask.ContinuousTaskRunner,
LocationListener,
DialogListener {
    private DefaultLocationSource defaultLocationSource;
    private String provider;
    private Dialog gpsDialog;

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.gpsDialog = null;
        this.getSourceProvider().removeSwitchTask();
        this.getSourceProvider().removeUpdateRequest();
        this.getSourceProvider().removeLocationUpdates(this);
    }

    @Override
    public void cancel() {
        this.getSourceProvider().getUpdateRequest().release();
        this.getSourceProvider().getProviderSwitchTask().stop();
    }

    @Override
    public void onPause() {
        super.onPause();
        this.getSourceProvider().getUpdateRequest().release();
        this.getSourceProvider().getProviderSwitchTask().pause();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.getSourceProvider().getUpdateRequest().run();
        if (this.isWaiting()) {
            this.getSourceProvider().getProviderSwitchTask().resume();
        }
        if (this.isDialogShowing() && this.isGPSProviderEnabled()) {
            this.gpsDialog.dismiss();
            this.onGPSActivated();
        }
    }

    @Override
    public boolean isDialogShowing() {
        return this.gpsDialog != null && this.gpsDialog.isShowing();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 25) {
            if (this.isGPSProviderEnabled()) {
                this.onGPSActivated();
            } else {
                LogUtils.logI("User didn't activate GPS, so continue with Network Provider");
                this.getLocationByNetwork();
            }
        }
    }

    @Override
    public void get() {
        this.setWaiting(true);
        if (this.isGPSProviderEnabled()) {
            LogUtils.logI("GPS is already enabled, getting location...");
            this.askForLocation("gps");
        } else if (this.getConfiguration().defaultProviderConfiguration().askForEnableGPS() && this.getActivity() != null) {
            LogUtils.logI("GPS is not enabled, asking user to enable it...");
            this.askForEnableGPS();
        } else {
            LogUtils.logI("GPS is not enabled, moving on with Network...");
            this.getLocationByNetwork();
        }
    }

    void askForEnableGPS() {
        DialogProvider gpsDialogProvider = this.getConfiguration().defaultProviderConfiguration().gpsDialogProvider();
        gpsDialogProvider.setDialogListener(this);
        this.gpsDialog = gpsDialogProvider.getDialog((Context)this.getActivity());
        this.gpsDialog.show();
    }

    void onGPSActivated() {
        LogUtils.logI("User activated GPS, listen for location");
        this.askForLocation("gps");
    }

    void getLocationByNetwork() {
        if (this.isNetworkProviderEnabled()) {
            LogUtils.logI("Network is enabled, getting location...");
            this.askForLocation("network");
        } else {
            LogUtils.logI("Network is not enabled, calling fail...");
            this.onLocationFailed(3);
        }
    }

    void askForLocation(String provider) {
        this.getSourceProvider().getProviderSwitchTask().stop();
        this.setCurrentProvider(provider);
        boolean locationIsAlreadyAvailable = this.checkForLastKnowLocation();
        if (this.getConfiguration().keepTracking() || !locationIsAlreadyAvailable) {
            LogUtils.logI("Ask for location update...");
            this.notifyProcessChange();
            if (!locationIsAlreadyAvailable) {
                this.getSourceProvider().getProviderSwitchTask().delayed(this.getWaitPeriod());
            }
            this.requestUpdateLocation();
        } else {
            LogUtils.logI("We got location, no need to ask for location updates.");
        }
    }

    boolean checkForLastKnowLocation() {
        Location lastKnownLocation = this.getSourceProvider().getLastKnownLocation(this.provider);
        if (this.getSourceProvider().isLocationSufficient(lastKnownLocation, this.getConfiguration().defaultProviderConfiguration().acceptableTimePeriod(), this.getConfiguration().defaultProviderConfiguration().acceptableAccuracy())) {
            LogUtils.logI("LastKnowLocation is usable.");
            this.onLocationReceived(lastKnownLocation);
            return true;
        }
        LogUtils.logI("LastKnowLocation is not usable.");
        return false;
    }

    void setCurrentProvider(String provider) {
        this.provider = provider;
    }

    void notifyProcessChange() {
        if (this.getListener() != null) {
            this.getListener().onProcessTypeChanged("gps".equals(this.provider) ? 3 : 4);
        }
    }

    void requestUpdateLocation() {
        long timeInterval = this.getConfiguration().defaultProviderConfiguration().requiredTimeInterval();
        long distanceInterval = this.getConfiguration().defaultProviderConfiguration().requiredDistanceInterval();
        this.getSourceProvider().getUpdateRequest().run(this.provider, timeInterval, distanceInterval);
    }

    long getWaitPeriod() {
        return "gps".equals(this.provider) ? this.getConfiguration().defaultProviderConfiguration().gpsWaitPeriod() : this.getConfiguration().defaultProviderConfiguration().networkWaitPeriod();
    }

    private boolean isNetworkProviderEnabled() {
        return this.getSourceProvider().isProviderEnabled("network");
    }

    private boolean isGPSProviderEnabled() {
        return this.getSourceProvider().isProviderEnabled("gps");
    }

    void onLocationReceived(Location location) {
        if (this.getListener() != null) {
            this.getListener().onLocationChanged(location);
        }
        this.setWaiting(false);
    }

    void onLocationFailed(int type) {
        if (this.getListener() != null) {
            this.getListener().onLocationFailed(type);
        }
        this.setWaiting(false);
    }

    public void onLocationChanged(Location location) {
        if (this.getSourceProvider().updateRequestIsRemoved()) {
            return;
        }
        this.onLocationReceived(location);
        if (!this.getSourceProvider().switchTaskIsRemoved()) {
            this.getSourceProvider().getProviderSwitchTask().stop();
        }
        if (!this.getConfiguration().keepTracking()) {
            this.getSourceProvider().getUpdateRequest().release();
            this.getSourceProvider().removeLocationUpdates(this);
        }
    }

    @Deprecated
    public void onStatusChanged(String provider, int status, Bundle extras) {
        if (this.getListener() != null) {
            this.getListener().onStatusChanged(provider, status, extras);
        }
    }

    public void onProviderEnabled(String provider) {
        if (this.getListener() != null) {
            this.getListener().onProviderEnabled(provider);
        }
    }

    public void onProviderDisabled(String provider) {
        if (this.getListener() != null) {
            this.getListener().onProviderDisabled(provider);
        }
    }

    @Override
    public void runScheduledTask(@NonNull String taskId) {
        if (taskId.equals("providerSwitchTask")) {
            this.getSourceProvider().getUpdateRequest().release();
            if ("gps".equals(this.provider)) {
                LogUtils.logI("We waited enough for GPS, switching to Network provider...");
                this.getLocationByNetwork();
            } else {
                LogUtils.logI("Network Provider is not provide location in required period, calling fail...");
                this.onLocationFailed(1);
            }
        }
    }

    @Override
    public void onPositiveButtonClick() {
        boolean activityStarted = this.startActivityForResult(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"), 25);
        if (!activityStarted) {
            this.onLocationFailed(9);
        }
    }

    @Override
    public void onNegativeButtonClick() {
        LogUtils.logI("User didn't want to enable GPS, so continue with Network Provider");
        this.getLocationByNetwork();
    }

    void setDefaultLocationSource(DefaultLocationSource defaultLocationSource) {
        this.defaultLocationSource = defaultLocationSource;
    }

    private DefaultLocationSource getSourceProvider() {
        if (this.defaultLocationSource == null) {
            this.defaultLocationSource = new DefaultLocationSource(this.getContext(), this, this);
        }
        return this.defaultLocationSource;
    }
}

