/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.locationprovider;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import com.yayandroid.locationmanager.helper.UpdateRequest;
import com.yayandroid.locationmanager.helper.continuoustask.ContinuousTask;
import java.util.Date;

class DefaultLocationSource {
    static final String PROVIDER_SWITCH_TASK = "providerSwitchTask";
    private LocationManager locationManager;
    private UpdateRequest updateRequest;
    private ContinuousTask cancelTask;

    DefaultLocationSource(Context context, ContinuousTask.ContinuousTaskRunner continuousTaskRunner, LocationListener locationListener) {
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.updateRequest = new UpdateRequest(this.locationManager, locationListener);
        this.cancelTask = new ContinuousTask(PROVIDER_SWITCH_TASK, continuousTaskRunner);
    }

    boolean isProviderEnabled(String provider) {
        return this.locationManager.isProviderEnabled(provider);
    }

    Location getLastKnownLocation(String provider) {
        return this.locationManager.getLastKnownLocation(provider);
    }

    void removeLocationUpdates(LocationListener locationListener) {
        this.locationManager.removeUpdates(locationListener);
    }

    void removeUpdateRequest() {
        this.updateRequest.release();
        this.updateRequest = null;
    }

    void removeSwitchTask() {
        this.cancelTask.stop();
        this.cancelTask = null;
    }

    boolean switchTaskIsRemoved() {
        return this.cancelTask == null;
    }

    boolean updateRequestIsRemoved() {
        return this.updateRequest == null;
    }

    ContinuousTask getProviderSwitchTask() {
        return this.cancelTask;
    }

    UpdateRequest getUpdateRequest() {
        return this.updateRequest;
    }

    boolean isLocationSufficient(Location location, long acceptableTimePeriod, float acceptableAccuracy) {
        if (location == null) {
            return false;
        }
        float givenAccuracy = location.getAccuracy();
        long givenTime = location.getTime();
        long minAcceptableTime = new Date().getTime() - acceptableTimePeriod;
        return minAcceptableTime <= givenTime && acceptableAccuracy >= givenAccuracy;
    }
}

