/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.locationprovider;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.helper.continuoustask.ContinuousTask;
import com.yayandroid.locationmanager.listener.FallbackListener;
import com.yayandroid.locationmanager.providers.locationprovider.DispatcherLocationSource;
import com.yayandroid.locationmanager.providers.locationprovider.GooglePlayServicesLocationProvider;
import com.yayandroid.locationmanager.providers.locationprovider.LocationProvider;

public class DispatcherLocationProvider
extends LocationProvider
implements ContinuousTask.ContinuousTaskRunner,
FallbackListener {
    private Dialog gpServicesDialog;
    private LocationProvider activeProvider;
    private DispatcherLocationSource dispatcherLocationSource;

    @Override
    public void onPause() {
        super.onPause();
        if (this.activeProvider != null) {
            this.activeProvider.onPause();
        }
        this.getSourceProvider().gpServicesSwitchTask().pause();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.activeProvider != null) {
            this.activeProvider.onResume();
        }
        this.getSourceProvider().gpServicesSwitchTask().resume();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.activeProvider != null) {
            this.activeProvider.onDestroy();
        }
        this.getSourceProvider().gpServicesSwitchTask().stop();
        this.dispatcherLocationSource = null;
        this.gpServicesDialog = null;
    }

    @Override
    public void cancel() {
        if (this.activeProvider != null) {
            this.activeProvider.cancel();
        }
        this.getSourceProvider().gpServicesSwitchTask().stop();
    }

    @Override
    public boolean isWaiting() {
        return this.activeProvider != null && this.activeProvider.isWaiting();
    }

    @Override
    public boolean isDialogShowing() {
        boolean gpServicesDialogShown = this.gpServicesDialog != null && this.gpServicesDialog.isShowing();
        boolean anyProviderDialogShown = this.activeProvider != null && this.activeProvider.isDialogShowing();
        return gpServicesDialogShown || anyProviderDialogShown;
    }

    @Override
    public void runScheduledTask(@NonNull String taskId) {
        if (taskId.equals("googlePlayServiceSwitchTask") && this.activeProvider instanceof GooglePlayServicesLocationProvider && this.activeProvider.isWaiting()) {
            LogUtils.logI("We couldn't receive location from GooglePlayServices, so switching default providers...");
            this.cancel();
            this.continueWithDefaultProviders();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 24) {
            this.checkGooglePlayServicesAvailability(false);
        } else if (this.activeProvider != null) {
            this.activeProvider.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void get() {
        if (this.getConfiguration().googlePlayServicesConfiguration() != null) {
            this.checkGooglePlayServicesAvailability(true);
        } else {
            LogUtils.logI("Configuration requires not to use Google Play Services, so skipping that step to Default Location Providers");
            this.continueWithDefaultProviders();
        }
    }

    @Override
    public void onFallback() {
        this.cancel();
        this.continueWithDefaultProviders();
    }

    void checkGooglePlayServicesAvailability(boolean askForGooglePlayServices) {
        int gpServicesAvailability = this.getSourceProvider().isGoogleApiAvailable(this.getContext());
        if (gpServicesAvailability == 0) {
            LogUtils.logI("GooglePlayServices is available on device.");
            this.getLocationFromGooglePlayServices();
        } else {
            LogUtils.logI("GooglePlayServices is NOT available on device.");
            if (askForGooglePlayServices) {
                this.askForGooglePlayServices(gpServicesAvailability);
            } else {
                LogUtils.logI("GooglePlayServices is NOT available and even though we ask user to handle error, it is still NOT available.");
                this.continueWithDefaultProviders();
            }
        }
    }

    void askForGooglePlayServices(int gpServicesAvailability) {
        if (this.getConfiguration().googlePlayServicesConfiguration().askForGooglePlayServices() && this.getSourceProvider().isGoogleApiErrorUserResolvable(gpServicesAvailability)) {
            this.resolveGooglePlayServices(gpServicesAvailability);
        } else {
            LogUtils.logI("Either GooglePlayServices error is not resolvable or the configuration doesn't wants us to bother user.");
            this.continueWithDefaultProviders();
        }
    }

    void resolveGooglePlayServices(int gpServicesAvailability) {
        LogUtils.logI("Asking user to handle GooglePlayServices error...");
        this.gpServicesDialog = this.getSourceProvider().getGoogleApiErrorDialog(this.getActivity(), gpServicesAvailability, 24, new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                LogUtils.logI("GooglePlayServices error could've been resolved, but user canceled it.");
                DispatcherLocationProvider.this.continueWithDefaultProviders();
            }
        });
        if (this.gpServicesDialog != null) {
            switch (gpServicesAvailability) {
                case 9: 
                case 18: {
                    this.gpServicesDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialog) {
                            LogUtils.logI("GooglePlayServices error could not have been resolved");
                            DispatcherLocationProvider.this.continueWithDefaultProviders();
                        }
                    });
                }
            }
            this.gpServicesDialog.show();
        } else {
            LogUtils.logI("GooglePlayServices error could've been resolved, but since LocationManager is not running on an Activity, dialog cannot be displayed.");
            this.continueWithDefaultProviders();
        }
    }

    void getLocationFromGooglePlayServices() {
        LogUtils.logI("Attempting to get location from Google Play Services providers...");
        this.setLocationProvider(this.getSourceProvider().createGooglePlayServicesLocationProvider(this));
        this.getSourceProvider().gpServicesSwitchTask().delayed(this.getConfiguration().googlePlayServicesConfiguration().googlePlayServicesWaitPeriod());
        this.activeProvider.get();
    }

    void continueWithDefaultProviders() {
        if (this.getConfiguration().defaultProviderConfiguration() == null) {
            LogUtils.logI("Configuration requires not to use default providers, abort!");
            if (this.getListener() != null) {
                this.getListener().onLocationFailed(4);
            }
        } else {
            LogUtils.logI("Attempting to get location from default providers...");
            this.setLocationProvider(this.getSourceProvider().createDefaultLocationProvider());
            this.activeProvider.get();
        }
    }

    void setLocationProvider(LocationProvider provider) {
        this.activeProvider = provider;
        this.activeProvider.configure(this);
    }

    void setDispatcherLocationSource(DispatcherLocationSource dispatcherLocationSource) {
        this.dispatcherLocationSource = dispatcherLocationSource;
    }

    private DispatcherLocationSource getSourceProvider() {
        if (this.dispatcherLocationSource == null) {
            this.dispatcherLocationSource = new DispatcherLocationSource(this);
        }
        return this.dispatcherLocationSource;
    }
}

