/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.locationprovider;

import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.Task;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.listener.FallbackListener;
import com.yayandroid.locationmanager.providers.locationprovider.GooglePlayServicesLocationSource;
import com.yayandroid.locationmanager.providers.locationprovider.LocationProvider;
import java.lang.ref.WeakReference;

public class GooglePlayServicesLocationProvider
extends LocationProvider
implements GooglePlayServicesLocationSource.SourceListener {
    private final WeakReference<FallbackListener> fallbackListener;
    private boolean settingsDialogIsOn = false;
    private GooglePlayServicesLocationSource googlePlayServicesLocationSource;

    GooglePlayServicesLocationProvider(FallbackListener fallbackListener) {
        this.fallbackListener = new WeakReference<FallbackListener>(fallbackListener);
    }

    @Override
    public void onResume() {
        if (!this.settingsDialogIsOn && (this.isWaiting() || this.getConfiguration().keepTracking())) {
            this.requestLocationUpdate();
        }
    }

    @Override
    public void onPause() {
        if (!this.settingsDialogIsOn && this.googlePlayServicesLocationSource != null) {
            this.removeLocationUpdates();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.googlePlayServicesLocationSource != null) {
            this.removeLocationUpdates();
        }
    }

    @Override
    public boolean isDialogShowing() {
        return this.settingsDialogIsOn;
    }

    @Override
    public void get() {
        this.setWaiting(true);
        if (this.getContext() != null) {
            LogUtils.logI("Start request location updates.");
            if (this.getConfiguration().googlePlayServicesConfiguration().ignoreLastKnowLocation()) {
                LogUtils.logI("Configuration requires to ignore last know location from GooglePlayServices Api.");
                this.locationRequired();
            } else {
                this.getSourceProvider().requestLastLocation();
            }
        } else {
            this.failed(8);
        }
    }

    @Override
    public void cancel() {
        LogUtils.logI("Canceling GooglePlayServiceLocationProvider...");
        if (this.googlePlayServicesLocationSource != null) {
            this.removeLocationUpdates();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 26) {
            this.settingsDialogIsOn = false;
            if (resultCode == -1) {
                LogUtils.logI("We got settings changed, requesting location update...");
                this.requestLocationUpdate();
            } else {
                LogUtils.logI("User denied settingsApi dialog, GooglePlayServices SettingsApi failing...");
                this.settingsApiFail(7);
            }
        }
    }

    public void onLocationChanged(@NonNull Location location) {
        if (this.getListener() != null) {
            this.getListener().onLocationChanged(location);
        }
        this.setWaiting(false);
        if (!this.getConfiguration().keepTracking()) {
            LogUtils.logI("We got location and no need to keep tracking, so location update is removed.");
            this.removeLocationUpdates();
        }
    }

    @Override
    public void onLocationResult(@Nullable LocationResult locationResult) {
        if (locationResult == null) {
            return;
        }
        for (Location location : locationResult.getLocations()) {
            this.onLocationChanged(location);
        }
    }

    @Override
    public void onSuccess(LocationSettingsResponse locationSettingsResponse) {
        LogUtils.logI("We got GPS, Wifi and/or Cell network providers enabled enough to receive location as we needed. Requesting location update...");
        this.requestLocationUpdate();
    }

    @Override
    public void onFailure(@NonNull Exception exception) {
        int statusCode = ((ApiException)exception).getStatusCode();
        switch (statusCode) {
            case 8502: {
                LogUtils.logE("Settings change is not available, SettingsApi failing...");
                this.settingsApiFail(6);
                break;
            }
            case 6: {
                this.resolveSettingsApi((ResolvableApiException)exception);
                break;
            }
            default: {
                LogUtils.logE("LocationSettings failing, status: " + CommonStatusCodes.getStatusCodeString((int)statusCode));
                this.settingsApiFail(7);
            }
        }
    }

    void resolveSettingsApi(@NonNull ResolvableApiException resolvable) {
        try {
            LogUtils.logI("We need settingsApi dialog to switch required settings on.");
            if (this.getActivity() != null) {
                LogUtils.logI("Displaying the dialog...");
                this.getSourceProvider().startSettingsApiResolutionForResult(resolvable, this.getActivity());
                this.settingsDialogIsOn = true;
            } else {
                LogUtils.logI("Settings Api cannot show dialog if LocationManager is not running on an activity!");
                this.settingsApiFail(9);
            }
        }
        catch (IntentSender.SendIntentException e) {
            LogUtils.logE("Error on displaying SettingsApi dialog, SettingsApi failing...");
            this.settingsApiFail(6);
        }
    }

    @Override
    public void onLastKnowLocationTaskReceived(@NonNull Task<Location> task) {
        if (task.isSuccessful() && task.getResult() != null) {
            Location lastKnownLocation = (Location)task.getResult();
            LogUtils.logI("LastKnowLocation is available.");
            this.onLocationChanged(lastKnownLocation);
            if (this.getConfiguration().keepTracking()) {
                LogUtils.logI("Configuration requires keepTracking.");
                this.locationRequired();
            }
        } else {
            LogUtils.logI("LastKnowLocation is not available.");
            this.locationRequired();
        }
    }

    void locationRequired() {
        LogUtils.logI("Ask for location update...");
        if (this.getConfiguration().googlePlayServicesConfiguration().askForSettingsApi()) {
            LogUtils.logI("Asking for SettingsApi...");
            this.getSourceProvider().checkLocationSettings();
        } else {
            LogUtils.logI("SettingsApi is not enabled, requesting for location update...");
            this.requestLocationUpdate();
        }
    }

    void requestLocationUpdate() {
        if (this.getListener() != null) {
            this.getListener().onProcessTypeChanged(2);
        }
        LogUtils.logI("Requesting location update...");
        this.getSourceProvider().requestLocationUpdate();
    }

    void settingsApiFail(int failType) {
        if (this.getConfiguration().googlePlayServicesConfiguration().failOnSettingsApiSuspended()) {
            this.failed(failType);
        } else {
            LogUtils.logE("Even though settingsApi failed, configuration requires moving on. So requesting location update...");
            this.requestLocationUpdate();
        }
    }

    void failed(int type) {
        if (this.getConfiguration().googlePlayServicesConfiguration().fallbackToDefault() && this.fallbackListener.get() != null) {
            ((FallbackListener)this.fallbackListener.get()).onFallback();
        } else if (this.getListener() != null) {
            this.getListener().onLocationFailed(type);
        }
        this.setWaiting(false);
    }

    void setDispatcherLocationSource(GooglePlayServicesLocationSource googlePlayServicesLocationSource) {
        this.googlePlayServicesLocationSource = googlePlayServicesLocationSource;
    }

    private GooglePlayServicesLocationSource getSourceProvider() {
        if (this.googlePlayServicesLocationSource == null) {
            this.googlePlayServicesLocationSource = new GooglePlayServicesLocationSource(this.getContext(), this.getConfiguration().googlePlayServicesConfiguration().locationRequest(), this);
        }
        return this.googlePlayServicesLocationSource;
    }

    private void removeLocationUpdates() {
        LogUtils.logI("Stop location updates...");
        if (this.googlePlayServicesLocationSource != null) {
            this.setWaiting(false);
            this.googlePlayServicesLocationSource.removeLocationUpdates();
        }
    }
}

