/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.locationprovider;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.Location;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;

class GooglePlayServicesLocationSource
extends LocationCallback {
    private final FusedLocationProviderClient fusedLocationProviderClient;
    private final LocationRequest locationRequest;
    private final SourceListener sourceListener;

    GooglePlayServicesLocationSource(Context context, LocationRequest locationRequest, SourceListener sourceListener) {
        this.sourceListener = sourceListener;
        this.locationRequest = locationRequest;
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
    }

    void checkLocationSettings() {
        LocationServices.getSettingsClient((Context)this.fusedLocationProviderClient.getApplicationContext()).checkLocationSettings(new LocationSettingsRequest.Builder().addLocationRequest(this.locationRequest).build()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<LocationSettingsResponse>(){

            public void onSuccess(LocationSettingsResponse locationSettingsResponse) {
                if (GooglePlayServicesLocationSource.this.sourceListener != null) {
                    GooglePlayServicesLocationSource.this.sourceListener.onSuccess(locationSettingsResponse);
                }
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                if (GooglePlayServicesLocationSource.this.sourceListener != null) {
                    GooglePlayServicesLocationSource.this.sourceListener.onFailure(exception);
                }
            }
        });
    }

    void startSettingsApiResolutionForResult(@NonNull ResolvableApiException resolvable, Activity activity) throws IntentSender.SendIntentException {
        resolvable.startResolutionForResult(activity, 26);
    }

    void requestLocationUpdate() {
        this.fusedLocationProviderClient.requestLocationUpdates(this.locationRequest, (LocationCallback)this, Looper.myLooper());
    }

    @NonNull
    Task<Void> removeLocationUpdates() {
        return this.fusedLocationProviderClient.removeLocationUpdates((LocationCallback)this);
    }

    void requestLastLocation() {
        this.fusedLocationProviderClient.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

            public void onComplete(@NonNull Task<Location> task) {
                if (GooglePlayServicesLocationSource.this.sourceListener != null) {
                    GooglePlayServicesLocationSource.this.sourceListener.onLastKnowLocationTaskReceived(task);
                }
            }
        });
    }

    public void onLocationResult(@Nullable LocationResult locationResult) {
        if (this.sourceListener != null) {
            this.sourceListener.onLocationResult(locationResult);
        }
    }

    static interface SourceListener
    extends OnSuccessListener<LocationSettingsResponse>,
    OnFailureListener {
        public void onSuccess(LocationSettingsResponse var1);

        public void onFailure(@NonNull Exception var1);

        public void onLocationResult(@Nullable LocationResult var1);

        public void onLastKnowLocationTaskReceived(@NonNull Task<Location> var1);
    }
}

