/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.locationprovider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.yayandroid.locationmanager.configuration.LocationConfiguration;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.listener.LocationListener;
import com.yayandroid.locationmanager.view.ContextProcessor;
import java.lang.ref.WeakReference;

public abstract class LocationProvider {
    private boolean isWaiting = false;
    private LocationConfiguration configuration;
    private ContextProcessor contextProcessor;
    private WeakReference<LocationListener> weakLocationListener;

    @CallSuper
    public void configure(ContextProcessor contextProcessor, LocationConfiguration configuration, LocationListener listener) {
        this.contextProcessor = contextProcessor;
        this.configuration = configuration;
        this.weakLocationListener = new WeakReference<LocationListener>(listener);
        this.initialize();
    }

    @CallSuper
    public void configure(LocationProvider locationProvider) {
        this.contextProcessor = locationProvider.contextProcessor;
        this.configuration = locationProvider.configuration;
        this.weakLocationListener = locationProvider.weakLocationListener;
        this.initialize();
    }

    public abstract boolean isDialogShowing();

    public abstract void get();

    public abstract void cancel();

    public void setWaiting(boolean waiting) {
        this.isWaiting = waiting;
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void initialize() {
    }

    @CallSuper
    public void onDestroy() {
        this.weakLocationListener.clear();
    }

    public void onPause() {
    }

    public void onResume() {
    }

    protected LocationConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    protected LocationListener getListener() {
        return (LocationListener)this.weakLocationListener.get();
    }

    @Nullable
    protected Context getContext() {
        return this.contextProcessor.getContext();
    }

    @Nullable
    protected Activity getActivity() {
        return this.contextProcessor.getActivity();
    }

    @Nullable
    protected Fragment getFragment() {
        return this.contextProcessor.getFragment();
    }

    protected boolean startActivityForResult(Intent intent, int requestCode) {
        if (this.getFragment() != null) {
            this.getFragment().startActivityForResult(intent, requestCode);
        } else if (this.getActivity() != null) {
            this.getActivity().startActivityForResult(intent, requestCode);
        } else {
            LogUtils.logE("Cannot startActivityForResult because host is neither Activity nor Fragment.");
            return false;
        }
        return true;
    }
}

