/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.permissionprovider;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.listener.DialogListener;
import com.yayandroid.locationmanager.providers.dialogprovider.DialogProvider;
import com.yayandroid.locationmanager.providers.permissionprovider.PermissionCompatSource;
import com.yayandroid.locationmanager.providers.permissionprovider.PermissionProvider;

public class DefaultPermissionProvider
extends PermissionProvider
implements DialogListener {
    private PermissionCompatSource permissionCompatSource;

    public DefaultPermissionProvider(String[] requiredPermissions, @Nullable DialogProvider dialogProvider) {
        super(requiredPermissions, dialogProvider);
    }

    @Override
    public boolean requestPermissions() {
        if (this.getActivity() == null) {
            LogUtils.logI("Cannot ask for permissions, because DefaultPermissionProvider doesn't contain an Activity instance.");
            return false;
        }
        if (this.shouldShowRequestPermissionRationale()) {
            this.getDialogProvider().setDialogListener(this);
            this.getDialogProvider().getDialog((Context)this.getActivity()).show();
        } else {
            this.executePermissionsRequest();
        }
        return true;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 23) {
            boolean isDenied = false;
            int size = permissions.length;
            for (int i = 0; i < size; ++i) {
                if (grantResults[i] == 0) continue;
                isDenied = true;
            }
            if (isDenied) {
                LogUtils.logI("User denied some of required permissions, task will be aborted!");
                if (this.getPermissionListener() != null) {
                    this.getPermissionListener().onPermissionsDenied();
                }
            } else {
                LogUtils.logI("We got all required permission!");
                if (this.getPermissionListener() != null) {
                    this.getPermissionListener().onPermissionsGranted();
                }
            }
        }
    }

    @Override
    public void onPositiveButtonClick() {
        this.executePermissionsRequest();
    }

    @Override
    public void onNegativeButtonClick() {
        LogUtils.logI("User didn't even let us to ask for permission!");
        if (this.getPermissionListener() != null) {
            this.getPermissionListener().onPermissionsDenied();
        }
    }

    boolean shouldShowRequestPermissionRationale() {
        boolean shouldShowRationale = false;
        for (String permission2 : this.getRequiredPermissions()) {
            shouldShowRationale = shouldShowRationale || this.checkRationaleForPermission(permission2);
        }
        LogUtils.logI("Should show rationale dialog for required permissions: " + shouldShowRationale);
        return shouldShowRationale && this.getActivity() != null && this.getDialogProvider() != null;
    }

    boolean checkRationaleForPermission(String permission2) {
        if (this.getFragment() != null) {
            return this.getPermissionCompatSource().shouldShowRequestPermissionRationale(this.getFragment(), permission2);
        }
        if (this.getActivity() != null) {
            return this.getPermissionCompatSource().shouldShowRequestPermissionRationale(this.getActivity(), permission2);
        }
        return false;
    }

    void executePermissionsRequest() {
        LogUtils.logI("Asking for Runtime Permissions...");
        if (this.getFragment() != null) {
            this.getPermissionCompatSource().requestPermissions(this.getFragment(), this.getRequiredPermissions(), 23);
        } else if (this.getActivity() != null) {
            this.getPermissionCompatSource().requestPermissions(this.getActivity(), this.getRequiredPermissions(), 23);
        } else {
            LogUtils.logE("Something went wrong requesting for permissions.");
            if (this.getPermissionListener() != null) {
                this.getPermissionListener().onPermissionsDenied();
            }
        }
    }

    void setPermissionCompatSource(PermissionCompatSource permissionCompatSource) {
        this.permissionCompatSource = permissionCompatSource;
    }

    protected PermissionCompatSource getPermissionCompatSource() {
        if (this.permissionCompatSource == null) {
            this.permissionCompatSource = new PermissionCompatSource();
        }
        return this.permissionCompatSource;
    }
}

