/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.providers.permissionprovider;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.yayandroid.locationmanager.helper.LogUtils;
import com.yayandroid.locationmanager.listener.PermissionListener;
import com.yayandroid.locationmanager.providers.dialogprovider.DialogProvider;
import com.yayandroid.locationmanager.view.ContextProcessor;
import java.lang.ref.WeakReference;

public abstract class PermissionProvider {
    private WeakReference<ContextProcessor> weakContextProcessor;
    private WeakReference<PermissionListener> weakPermissionListener;
    private final String[] requiredPermissions;
    private DialogProvider rationalDialogProvider;

    public PermissionProvider(String[] requiredPermissions, @Nullable DialogProvider rationaleDialogProvider) {
        if (requiredPermissions == null || requiredPermissions.length == 0) {
            throw new IllegalStateException("You cannot create PermissionProvider without any permission required.");
        }
        this.requiredPermissions = requiredPermissions;
        this.rationalDialogProvider = rationaleDialogProvider;
    }

    public abstract boolean requestPermissions();

    public abstract void onRequestPermissionsResult(int var1, @Nullable String[] var2, @NonNull int[] var3);

    public String[] getRequiredPermissions() {
        return this.requiredPermissions;
    }

    @Nullable
    public DialogProvider getDialogProvider() {
        return this.rationalDialogProvider;
    }

    @Nullable
    public PermissionListener getPermissionListener() {
        return (PermissionListener)this.weakPermissionListener.get();
    }

    @Nullable
    protected Context getContext() {
        return this.weakContextProcessor.get() == null ? null : ((ContextProcessor)this.weakContextProcessor.get()).getContext();
    }

    @Nullable
    protected Activity getActivity() {
        return this.weakContextProcessor.get() == null ? null : ((ContextProcessor)this.weakContextProcessor.get()).getActivity();
    }

    @Nullable
    protected Fragment getFragment() {
        return this.weakContextProcessor.get() == null ? null : ((ContextProcessor)this.weakContextProcessor.get()).getFragment();
    }

    @CallSuper
    public void setContextProcessor(ContextProcessor contextProcessor) {
        this.weakContextProcessor = new WeakReference<ContextProcessor>(contextProcessor);
    }

    @CallSuper
    public void setPermissionListener(PermissionListener permissionListener) {
        this.weakPermissionListener = new WeakReference<PermissionListener>(permissionListener);
    }

    public boolean hasPermission() {
        if (this.getContext() == null) {
            LogUtils.logE("Couldn't check whether permissions are granted or not because of PermissionProvider doesn't contain any context.");
            return false;
        }
        for (String permission2 : this.getRequiredPermissions()) {
            if (this.checkSelfPermission(permission2) == 0) continue;
            return false;
        }
        return true;
    }

    protected int checkSelfPermission(String permission2) {
        return ContextCompat.checkSelfPermission((Context)this.getContext(), (String)permission2);
    }
}

