/*
 * Decompiled with CFR 0.152.
 */
package com.yayandroid.locationmanager.view;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;

public class ContextProcessor {
    private Context applicationContext;
    private WeakReference<Activity> weakActivity;
    private WeakReference<Fragment> weakFragment;

    public ContextProcessor(Context context) {
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("ContextProcessor can only be initialized with Application!");
        }
        this.applicationContext = context;
        this.weakActivity = new WeakReference<Object>(null);
        this.weakFragment = new WeakReference<Object>(null);
    }

    public ContextProcessor setActivity(Activity activity) {
        this.weakActivity = new WeakReference<Activity>(activity);
        this.weakFragment = new WeakReference<Object>(null);
        return this;
    }

    public ContextProcessor setFragment(Fragment fragment) {
        this.weakActivity = new WeakReference<Object>(null);
        this.weakFragment = new WeakReference<Fragment>(fragment);
        return this;
    }

    @Nullable
    public Fragment getFragment() {
        return (Fragment)this.weakFragment.get();
    }

    @Nullable
    public Activity getActivity() {
        if (this.weakActivity.get() != null) {
            return (Activity)this.weakActivity.get();
        }
        if (this.weakFragment.get() != null && ((Fragment)this.weakFragment.get()).getActivity() != null) {
            return ((Fragment)this.weakFragment.get()).getActivity();
        }
        return null;
    }

    public Context getContext() {
        return this.applicationContext;
    }
}

