/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.ybrikman.ping.javaapi.bigpipe.BigPipe;
import com.ybrikman.ping.javaapi.bigpipe.HtmlPagelet;
import com.ybrikman.ping.javaapi.bigpipe.HtmlStreamHelper;
import com.ybrikman.ping.javaapi.bigpipe.JsonPagelet;
import com.ybrikman.ping.javaapi.bigpipe.PageletRenderOptions;
import com.ybrikman.ping.scalaapi.bigpipe.HtmlStream;
import com.ybrikman.ping.scalaapi.bigpipe.Pagelet;
import data.FakeServiceClient$;
import data.Response;
import helper.FakeServiceClient;
import javax.inject.Inject;
import play.libs.F;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Html;
import views.html.helpers.error;
import views.html.helpers.module;
import views.stream.clientSideTemplating;
import views.stream.escaping;
import views.stream.withBigPipe;

public class MoreBigPipeExamples
extends Controller {
    private final FakeServiceClient serviceClient;

    @Inject
    public MoreBigPipeExamples(FakeServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public Result serverSideRendering() {
        F.Promise<Response> profilePromise = this.serviceClient.fakeRemoteCallMedium("profile");
        F.Promise<Response> graphPromise = this.serviceClient.fakeRemoteCallMedium("graph");
        F.Promise<Response> feedPromise = this.serviceClient.fakeRemoteCallSlow("feed");
        F.Promise<Response> inboxPromise = this.serviceClient.fakeRemoteCallSlow("inbox");
        F.Promise<Response> adsPromise = this.serviceClient.fakeRemoteCallFast("ads");
        F.Promise<Response> searchPromise = this.serviceClient.fakeRemoteCallFast("search");
        HtmlPagelet profile = new HtmlPagelet("profile", profilePromise.map(module::apply));
        HtmlPagelet graph = new HtmlPagelet("graph", graphPromise.map(module::apply));
        HtmlPagelet feed = new HtmlPagelet("feed", feedPromise.map(module::apply));
        HtmlPagelet inbox = new HtmlPagelet("inbox", inboxPromise.map(module::apply));
        HtmlPagelet ads = new HtmlPagelet("ads", adsPromise.map(module::apply));
        HtmlPagelet search = new HtmlPagelet("search", searchPromise.map(module::apply));
        BigPipe bigPipe = new BigPipe(PageletRenderOptions.ServerSide, new com.ybrikman.ping.javaapi.bigpipe.Pagelet[]{profile, graph, feed, inbox, ads, search});
        return MoreBigPipeExamples.ok((Results.Chunks)HtmlStreamHelper.toChunks((HtmlStream)withBigPipe.apply((com.ybrikman.ping.scalaapi.bigpipe.BigPipe)bigPipe, (Pagelet)profile, (Pagelet)graph, (Pagelet)feed, (Pagelet)inbox, (Pagelet)ads, (Pagelet)search)));
    }

    public Result clientSideTemplating() {
        F.Promise<JsonNode> profilePromise = this.serviceClient.fakeRemoteCallJsonMedium("profile");
        F.Promise<JsonNode> graphPromise = this.serviceClient.fakeRemoteCallJsonMedium("graph");
        F.Promise<JsonNode> feedPromise = this.serviceClient.fakeRemoteCallJsonSlow("feed");
        F.Promise<JsonNode> inboxPromise = this.serviceClient.fakeRemoteCallJsonSlow("inbox");
        F.Promise<JsonNode> adsPromise = this.serviceClient.fakeRemoteCallJsonFast("ads");
        F.Promise<JsonNode> searchPromise = this.serviceClient.fakeRemoteCallJsonFast("search");
        JsonPagelet profile = new JsonPagelet("profile", profilePromise);
        JsonPagelet graph = new JsonPagelet("graph", graphPromise);
        JsonPagelet feed = new JsonPagelet("feed", feedPromise);
        JsonPagelet inbox = new JsonPagelet("inbox", inboxPromise);
        JsonPagelet ads = new JsonPagelet("ads", adsPromise);
        JsonPagelet search = new JsonPagelet("search", searchPromise);
        BigPipe bigPipe = new BigPipe(PageletRenderOptions.ClientSide, new com.ybrikman.ping.javaapi.bigpipe.Pagelet[]{profile, graph, feed, inbox, ads, search});
        return MoreBigPipeExamples.ok((Results.Chunks)HtmlStreamHelper.toChunks((HtmlStream)clientSideTemplating.apply((com.ybrikman.ping.scalaapi.bigpipe.BigPipe)bigPipe, (Pagelet)profile, (Pagelet)graph, (Pagelet)feed, (Pagelet)inbox, (Pagelet)ads, (Pagelet)search)));
    }

    public Result errorHandling() {
        F.Promise<Response> profilePromise = this.serviceClient.fakeRemoteCallMedium("profile");
        F.Promise<Response> graphPromise = this.serviceClient.fakeRemoteCallMedium("graph");
        F.Promise<Response> feedPromise = this.serviceClient.fakeRemoteCallErrorSlow("feed");
        F.Promise<Response> inboxPromise = this.serviceClient.fakeRemoteCallSlow("inbox");
        F.Promise<Response> adsPromise = this.serviceClient.fakeRemoteCallFast("ads");
        F.Promise<Response> searchPromise = this.serviceClient.fakeRemoteCallFast("search");
        HtmlPagelet profile = new HtmlPagelet("profile", this.render(profilePromise));
        HtmlPagelet graph = new HtmlPagelet("graph", this.render(graphPromise));
        HtmlPagelet feed = new HtmlPagelet("feed", this.render(feedPromise));
        HtmlPagelet inbox = new HtmlPagelet("inbox", this.render(inboxPromise));
        HtmlPagelet ads = new HtmlPagelet("ads", this.render(adsPromise));
        HtmlPagelet search = new HtmlPagelet("search", this.render(searchPromise));
        BigPipe bigPipe = new BigPipe(PageletRenderOptions.ClientSide, new com.ybrikman.ping.javaapi.bigpipe.Pagelet[]{profile, graph, feed, inbox, ads, search});
        return MoreBigPipeExamples.ok((Results.Chunks)HtmlStreamHelper.toChunks((HtmlStream)withBigPipe.apply((com.ybrikman.ping.scalaapi.bigpipe.BigPipe)bigPipe, (Pagelet)profile, (Pagelet)graph, (Pagelet)feed, (Pagelet)inbox, (Pagelet)ads, (Pagelet)search)));
    }

    public Result escaping() {
        F.Promise<JsonNode> shouldBeEscapedPromise = this.serviceClient.fakeRemoteCallJsonFast(FakeServiceClient$.MODULE$.RESPONSE_TO_TEST_ESCAPING());
        JsonPagelet shouldBeEscaped = new JsonPagelet("shouldBeEscaped", shouldBeEscapedPromise);
        BigPipe bigPipe = new BigPipe(PageletRenderOptions.ClientSide, new com.ybrikman.ping.javaapi.bigpipe.Pagelet[]{shouldBeEscaped});
        return MoreBigPipeExamples.ok((Results.Chunks)HtmlStreamHelper.toChunks((HtmlStream)escaping.apply((com.ybrikman.ping.scalaapi.bigpipe.BigPipe)bigPipe, (Pagelet)shouldBeEscaped)));
    }

    private F.Promise<Html> render(F.Promise<Response> dataPromise) {
        return dataPromise.map(module::apply).recover(error::apply);
    }
}

