/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.ybrikman.ping.javaapi.bigpipe.BigPipe;
import com.ybrikman.ping.javaapi.bigpipe.HtmlPagelet;
import com.ybrikman.ping.javaapi.bigpipe.HtmlStreamHelper;
import com.ybrikman.ping.javaapi.bigpipe.Pagelet;
import com.ybrikman.ping.javaapi.bigpipe.PageletRenderOptions;
import com.ybrikman.ping.scalaapi.bigpipe.HtmlStream;
import data.Response;
import helper.FakeServiceClient;
import javax.inject.Inject;
import play.libs.F;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import views.html.helpers.module;
import views.stream.withBigPipe;

public class WithBigPipe
extends Controller {
    private final FakeServiceClient serviceClient;

    @Inject
    public WithBigPipe(FakeServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public Result index() {
        F.Promise<Response> profilePromise = this.serviceClient.fakeRemoteCallMedium("profile");
        F.Promise<Response> graphPromise = this.serviceClient.fakeRemoteCallMedium("graph");
        F.Promise<Response> feedPromise = this.serviceClient.fakeRemoteCallSlow("feed");
        F.Promise<Response> inboxPromise = this.serviceClient.fakeRemoteCallSlow("inbox");
        F.Promise<Response> adsPromise = this.serviceClient.fakeRemoteCallFast("ads");
        F.Promise<Response> searchPromise = this.serviceClient.fakeRemoteCallFast("search");
        HtmlPagelet profile = new HtmlPagelet("profile", profilePromise.map(module::apply));
        HtmlPagelet graph = new HtmlPagelet("graph", graphPromise.map(module::apply));
        HtmlPagelet feed = new HtmlPagelet("feed", feedPromise.map(module::apply));
        HtmlPagelet inbox = new HtmlPagelet("inbox", inboxPromise.map(module::apply));
        HtmlPagelet ads = new HtmlPagelet("ads", adsPromise.map(module::apply));
        HtmlPagelet search = new HtmlPagelet("search", searchPromise.map(module::apply));
        BigPipe bigPipe = new BigPipe(PageletRenderOptions.ClientSide, new Pagelet[]{profile, graph, feed, inbox, ads, search});
        return WithBigPipe.ok((Results.Chunks)HtmlStreamHelper.toChunks((HtmlStream)withBigPipe.apply((com.ybrikman.ping.scalaapi.bigpipe.BigPipe)bigPipe, (com.ybrikman.ping.scalaapi.bigpipe.Pagelet)profile, (com.ybrikman.ping.scalaapi.bigpipe.Pagelet)graph, (com.ybrikman.ping.scalaapi.bigpipe.Pagelet)feed, (com.ybrikman.ping.scalaapi.bigpipe.Pagelet)inbox, (com.ybrikman.ping.scalaapi.bigpipe.Pagelet)ads, (com.ybrikman.ping.scalaapi.bigpipe.Pagelet)search)));
    }
}

