/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public interface YopConstants {
    public static final String VERSION = "4.4.12";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final String DEFAULT_SERVER_ROOT = "https://openapi.yeepay.com/yop-center";
    public static final String DEFAULT_YOS_SERVER_ROOT = "https://yos.yeepay.com/yop-center";
    public static final String DEFAULT_SANDBOX_SERVER_ROOT = "https://sandbox.yeepay.com/yop-center";
    public static final List<URI> DEFAULT_PREFERRED_SERVER_ROOT = Lists.newArrayList((Object[])new URI[]{URI.create("https://openapi-a.yeepay.com/yop-center"), URI.create("https://openapi-h.yeepay.com/yop-center")});
    public static final String DEFAULT_SANDBOX_VIA = "sandbox";
    public static final String DEFAULT_YOP_PROTOCOL_VERSION = "yop-auth-v3";
    public static final String SM2_PROTOCOL_PREFIX = "YOP-SM2-SM3";
    public static final String YOP_RSA_PLATFORM_CERT_DEFAULT_SERIAL_NO = "rsa";
    public static final String YOP_SM_PLATFORM_CERT_DEFAULT_SERIAL_NO = "sm";
    public static final String YOP_RSA_PLATFORM_CERT_PREFIX = "yop_platform_rsa_cert_";
    public static final String YOP_SM_PLATFORM_CERT_PREFIX = "yop_platform_sm_cert_";
    public static final String YOP_PLATFORM_CERT_POSTFIX = ".cer";
    public static final String ISV_ENCRYPT_KEY = "ISV_ENCRYPT_KEY";
    public static final String YOP_RSA2048_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4g7dPL+CBeuzFmARI2GFjZpKODUROaMG+E6wdNfv5lhPqC3jjTIeljWU8AiruZLGRhl92QWcTjb3XonjaV6k9rf9adQtyv2FLS7bl2Vz2WgjJ0FJ5/qMaoXaT+oAgWFk2GypyvoIZsscsGpUStm6BxpWZpbPrGJR0N95un/130cQI9VCmfvgkkCaXt7TU1BbiYzkc8MDpLScGm/GUCB2wB5PclvOxvf5BR/zNVYywTEFmw2Jo0hIPPSWB5Yyf2mx950Fx8da56co/FxLdMwkDOO51Qg3fbaExQDVzTm8Odi++wVJEP1y34tlmpwFUVbAKIEbyyELmi/2S6GG0j9vNwIDAQAB";
    public static final String TLS_VERSION_1_1 = "TLSv1.1";
    public static final String TLS_VERSION_1_2 = "TLSv1.2";
    public static final String JDK_VERSION = "java.version";
    public static final String JDK_VERSION_1_6 = "1.6";
    public static final String JDK_VERSION_1_7 = "1.7";
    public static final String JDK_VERSION_1_8 = "1.8";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String RSA_ECB_PKCS1PADDING = "RSA/ECB/PKCS1Padding";
    public static final String YOP_HTTP_CLIENT_IMPL_OK = "ok";
    public static final String YOP_HTTP_CLIENT_IMPL_APACHE = "apache";
    public static final String YOP_HTTP_CLIENT_IMPL_DEFAULT = "apache";
    public static final String YOP_HTTP_CONTENT_TYPE_JSON = "application/json";
    public static final String YOP_HTTP_CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String YOP_HTTP_CONTENT_TYPE_MULTIPART_FORM = "multipart/form-data";
    public static final String YOP_HTTP_CONTENT_TYPE_STREAM = "application/octet-stream";
    public static final String YOP_HTTP_CONTENT_TYPE_TEXT = "text/plain;charset=UTF-8";
    public static final String YOP_DEFAULT_APPKEY = "default";
    public static final String YOP_DEFAULT_PROVIDER = "";
    public static final String YOP_DEFAULT_ENV = "";
    public static final String YOP_ENCRYPT_V1 = "yop-encrypt-v1";
    public static final String SM4_CBC_PKCS5PADDING = "SM4/CBC/PKCS5Padding";
    public static final String SM2 = "SM2";
    public static final String AES = "AES";
    public static final String AES_ECB_PKCS5PADDING = "AES/ECB/PKCS5Padding";
    public static final String RSA = "RSA";
    public static final String YOP_DEFAULT_ENCRYPT_ALG = "SM4/CBC/PKCS5Padding";
    public static final String YOP_CREDENTIALS_ENCRYPT_ALG_SM4 = "SM4/CBC/PKCS5Padding";
    public static final String YOP_CREDENTIALS_ENCRYPT_ALG_SM2 = "SM2";
    public static final String YOP_CREDENTIALS_ENCRYPT_ALG_RSA = "RSA";
    public static final String YOP_CREDENTIALS_DEFAULT_ENCRYPT_ALG = "SM2";
    public static final String YOP_ENCRYPT_OPTIONS_YOP_PLATFORM_CERT_SERIAL_NO = "YOP_PLATFORM_CERT_SERIAL_NO";
    public static final String YOP_ENCRYPT_OPTIONS_YOP_SM4_MAIN_CREDENTIALS = "SM4_CERT_ID";
    public static final String YOP_JSON_CONTENT_FORMAT = "{\"result\":%s}";
    public static final String YOP_JSON_CONTENT_BIZ_KEY = "result";
    public static final String JSON_PATH_PREFIX = "$.";
    public static final Set<String> JSON_PATH_ROOT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"$", "$..*"}));
    public static final Set<String> TOTAL_ENCRYPT_PARAMS = Sets.newHashSet((Object[])new String[]{"$"});
    public static final String DEFAULT_CERT_PATH = "config/certs";
    public static final String DEFAULT_CFCA_ROOT_FILE = "cfca_root.pem";
    public static final String DEFAULT_YOP_INTER_FILE = "yop_inter.pem";
    public static final YopCertStore DEFAULT_LOCAL_YOP_CERT_STORE = new YopCertStore("config/certs");
    public static final long DEFAULT_PERIOD_VALID_AFTER_EXPIRE = 86400000L;
    public static final long DEFAULT_PERIOD_REFRESH_BEFORE_EXPIRE = 259200000L;
    public static final String SM4_CALLBACK_ALGORITHM = "AEAD_SM4_GCM";
    public static final String DEFAULT_YOP_CALLBACK_HANDLER = "default";
    public static final String DEFAULT_YOP_CIRCUIT_BREAKER = "sentinel";
    public static final String YOP_SESSION_ID = UUID.randomUUID().toString();
    public static final String REPORT_API_URI = "/rest/v1.0/yop/client/report";
    public static final String REPORT_API_METHOD = "POST";
    public static final String HEADER_LANG_JAVA = "java";
    public static final boolean SDK_DEBUG = Boolean.parseBoolean(System.getProperty("yop.sdk.debug", "false"));
    public static final String YOP_SDK_SOURCE_BASIC = "basic";
    public static final String YOP_SDK_SOURCE_BIZ = "biz";
    public static final String PROVIDER_YEEPAY = "yeepay";
    public static final String PROVIDER_GPT = "gpt";
    public static final String ENV_PROD = "prod";
    public static final String ENV_SANDBOX = "sandbox";
    public static final String ENV_QA = "qa";
}

