/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.base.config.YopAppConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.PrivateKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBaseCredentialsProvider
implements YopCredentialsProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected YopCredentials<?> buildCredentials(YopAppConfig appConfig, String credentialType) {
        CertTypeEnum certType;
        if (null == appConfig || StringUtils.isEmpty((CharSequence)credentialType) || null == (certType = CertTypeEnum.parse((String)credentialType))) {
            throw new YopClientException("ConfigProblem, credentialType:" + credentialType + ", appConfig:" + appConfig);
        }
        PrivateKey privateKey = appConfig.loadPrivateKey(certType);
        if (null == privateKey) {
            throw new YopClientException("ConfigProblem, IsvPrivateCert NotFound, appKey:" + appConfig.getAppKey() + ", certType:" + certType);
        }
        PKICredentialsItem pkiCredentialsItem = new PKICredentialsItem(privateKey, certType);
        return new YopPKICredentials(appConfig.getAppKey(), pkiCredentialsItem);
    }

    protected String useDefaultIfBlank(String appKey) {
        return (String)StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)this.getDefaultAppKey());
    }

    protected String useDefaultIfBlank(String provider, String env, String appKey) {
        return (String)StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)this.getDefaultAppKey(provider, env));
    }

    public String getDefaultAppKey() {
        return this.getDefaultAppKey("", "");
    }

    public String getDefaultAppKey(String provider, String env) {
        return "default";
    }

    public YopCredentials<?> getCredentials(String appKey, String credentialType) {
        return this.getCredentials("", "", appKey, credentialType);
    }
}

