/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider.file;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.base.auth.credentials.provider.YopBasePlatformCredentialsProvider;
import com.yeepay.yop.sdk.base.cache.YopCertificateCache;
import com.yeepay.yop.sdk.base.security.cert.X509CertSupportFactory;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParserFactory;
import com.yeepay.yop.sdk.config.enums.CertStoreType;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import com.yeepay.yop.sdk.security.cert.YopPublicKey;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopFilePlatformCredentialsProvider
extends YopBasePlatformCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopFilePlatformCredentialsProvider.class);
    protected static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(2, 20, 3L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue((int)200), new ThreadFactoryBuilder().setNameFormat("yop-platform-cert-store-task-%d").setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    protected YopPlatformCredentials loadCredentialsFromStore(String appKey, String serialNo) {
        return this.loadCredentialsFromStore("", "", appKey, serialNo);
    }

    @Override
    protected YopPlatformCredentials loadCredentialsFromStore(String provider, String env, String appKey, String serialNo) {
        YopCertStore yopCertStore = ClientUtils.getCurrentSdkConfigProvider().getConfig(provider, env).getYopCertStore();
        Map<String, X509Certificate> localCerts = this.loadAndVerify(provider, env, appKey, yopCertStore, serialNo, false);
        if (MapUtils.isEmpty(localCerts) || !localCerts.containsKey(serialNo)) {
            localCerts = this.loadAndVerify(provider, env, appKey, YopConstants.DEFAULT_LOCAL_YOP_CERT_STORE, serialNo, true);
        }
        if (MapUtils.isNotEmpty(localCerts) && localCerts.containsKey(serialNo)) {
            return this.convertCredentials(appKey, CertTypeEnum.SM2.name(), localCerts.get(serialNo));
        }
        LOGGER.debug("no available platform cert from store, path:{}, serialNo:{}", (Object)yopCertStore.getPath(), (Object)serialNo);
        return null;
    }

    public YopPlatformCredentials storeCredentials(String appKey, String credentialType, X509Certificate cert) {
        return this.storeCredentials("", "", appKey, credentialType, cert);
    }

    @Override
    public YopPlatformCredentials storeCredentials(String provider, String env, String appKey, String credentialType, X509Certificate cert) {
        return this.doStore(provider, env, appKey, credentialType, cert);
    }

    private YopPlatformCredentials doStore(String provider, String env, String appKey, String credentialType, X509Certificate cert) {
        YopCertStore yopCertStore = ClientUtils.getCurrentSdkConfigProvider().getConfig(provider, env).getYopCertStore();
        YopPlatformCredentials result = this.convertCredentials(appKey, credentialType, cert);
        if (null == yopCertStore || !BooleanUtils.isTrue((Boolean)yopCertStore.getEnable())) {
            return result;
        }
        THREAD_POOL.submit(() -> {
            try {
                File certStoreDir = this.createStoreDirIfNecessary(provider, env, appKey, yopCertStore);
                if (null != certStoreDir) {
                    this.writeCertToFileStore(certStoreDir, cert);
                }
            }
            catch (Exception e) {
                LOGGER.warn("error when X509Certificate, ex:", (Throwable)e);
            }
        });
        return result;
    }

    private void writeCertToFileStore(File certStoreDir, X509Certificate cert) {
        try {
            String serialNo = X509CertUtils.parseToHex(cert.getSerialNumber().toString());
            File certFile = new File(certStoreDir, "yop_platform_sm_cert_" + serialNo + ".cer");
            if (!certFile.exists()) {
                X509CertSupportFactory.getSupport(CertTypeEnum.SM2.name()).writeToFile(cert, certFile);
            }
        }
        catch (Exception e) {
            LOGGER.error("error when write yop cert to file, ex:", (Throwable)e);
        }
    }

    private File createStoreDirIfNecessary(String provider, String env, String appKey, YopCertStore yopCertStore) {
        try {
            File certStoreDir = new File(X509CertUtils.getLocalCertDirByProviderAndEnv(yopCertStore.getPath(), provider, env, appKey));
            if (certStoreDir.exists() || certStoreDir.mkdirs()) {
                return certStoreDir;
            }
            LOGGER.warn("fail when create yop cert store dir, {}", (Object)yopCertStore);
        }
        catch (Exception e) {
            LOGGER.error("error when create yop cert store dir, ex:", (Throwable)e);
        }
        return null;
    }

    private Map<String, X509Certificate> loadAndVerify(String provider, String env, String appKey, YopCertStore yopCertStore, String serialNo, boolean innerConfig) {
        LOGGER.debug("begin load sm2 cert from local, provider:{}, env:{}, path:{}, serialNo:{}, isInner:{}", new Object[]{provider, env, yopCertStore.getPath(), serialNo, innerConfig});
        if (StringUtils.isBlank((CharSequence)yopCertStore.getPath()) || !BooleanUtils.isTrue((Boolean)yopCertStore.getEnable())) {
            return Collections.emptyMap();
        }
        Set<String> certDirsOrdered = X509CertUtils.getLocalCertDirs(yopCertStore.getPath(), provider, env, appKey);
        for (String certDir : certDirsOrdered) {
            Map<String, X509Certificate> certMap = this.doLoadAndVerify(provider, env, appKey, certDir, serialNo, innerConfig);
            if (!MapUtils.isNotEmpty(certMap)) continue;
            return certMap;
        }
        return Collections.emptyMap();
    }

    private Map<String, X509Certificate> doLoadAndVerify(String provider, String env, String appKey, String configDir, String serialNo, boolean innerConfig) {
        try {
            String filename = configDir + "/" + "yop_platform_sm_cert_" + serialNo + ".cer";
            if (!innerConfig && !new File(filename).exists()) {
                LOGGER.warn("wrong file path for sm2 cert, serialNo:{}, path:{}", (Object)serialNo, (Object)filename);
                return Collections.emptyMap();
            }
            HashMap certMap = Maps.newHashMap();
            YopCertConfig yopCertConfig = new YopCertConfig();
            yopCertConfig.setCertType(CertTypeEnum.SM2);
            yopCertConfig.setValue(filename);
            yopCertConfig.setStoreType(CertStoreType.FILE_CER);
            X509Certificate cert = ((YopPublicKey)YopCertParserFactory.getCertParser(YopCertCategory.PUBLIC, CertTypeEnum.SM2).parse(yopCertConfig)).getCert();
            String realSerialNo = X509CertUtils.parseToHex(cert.getSerialNumber().toString());
            X509CertUtils.verifyCertificate(provider, env, CertTypeEnum.SM2, YopCertificateCache.getYopInterCertFromLocal(provider, env, appKey).getPublicKey(), cert);
            if (!realSerialNo.equals(serialNo)) {
                LOGGER.warn("wrong file name for sm2 cert, serialNo:{}, realSerialNo:{}", (Object)serialNo, (Object)realSerialNo);
                certMap.put(serialNo, cert);
            }
            certMap.put(realSerialNo, cert);
            return certMap;
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 cert from local file, configDir:" + configDir + ",serialNo:" + serialNo + ", ex:", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

