/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yeepay.yop.sdk.base.security.encrypt.RsaEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.Sm2Enhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptionsEnhancer;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptOptionsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptOptionsCache.class);
    private static final LoadingCache<String, Future<EncryptOptions>> ENCRYPT_OPTIONS_CACHE = EncryptOptionsCache.initCache(24L, TimeUnit.HOURS);

    public static Future<EncryptOptions> loadEncryptOptions(String appKey, String encryptAlg) {
        return EncryptOptionsCache.loadEncryptOptions(appKey, encryptAlg, null);
    }

    public static Future<EncryptOptions> loadEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        return EncryptOptionsCache.loadEncryptOptions("", "", appKey, encryptAlg, serverRoot);
    }

    public static Future<EncryptOptions> loadEncryptOptions(String provider, String env, String appKey, String encryptAlg, String serverRoot) {
        try {
            return (Future)ENCRYPT_OPTIONS_CACHE.get((Object)EncryptOptionsCache.getCacheKey(provider, env, appKey, encryptAlg, serverRoot));
        }
        catch (ExecutionException e) {
            throw new YopClientException("ConfigProblem, LoadEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", (Throwable)e);
        }
    }

    public static void refreshEncryptOptions(String appKey, String encryptAlg) {
        EncryptOptionsCache.refreshEncryptOptions(appKey, encryptAlg, null);
    }

    public static void refreshEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        EncryptOptionsCache.refreshEncryptOptions("", "", appKey, encryptAlg, serverRoot);
    }

    public static void refreshEncryptOptions(String provider, String env, String appKey, String encryptAlg, String serverRoot) {
        try {
            ENCRYPT_OPTIONS_CACHE.refresh((Object)EncryptOptionsCache.getCacheKey(provider, env, appKey, encryptAlg, serverRoot));
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, RefreshEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", (Throwable)e);
        }
    }

    public static void invalidateEncryptOptions(String appKey, String encryptAlg) {
        EncryptOptionsCache.invalidateEncryptOptions(appKey, encryptAlg, null);
    }

    public static void invalidateEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        EncryptOptionsCache.invalidateEncryptOptions("", "", appKey, encryptAlg, serverRoot);
    }

    public static void invalidateEncryptOptions(String provider, String env, String appKey, String encryptAlg, String serverRoot) {
        try {
            ENCRYPT_OPTIONS_CACHE.invalidate((Object)EncryptOptionsCache.getCacheKey(provider, env, appKey, encryptAlg, serverRoot));
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, InvalidateEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", (Throwable)e);
        }
    }

    public static Future<EncryptOptions> reloadEncryptOptions(String appKey, String encryptAlg) {
        return EncryptOptionsCache.reloadEncryptOptions(appKey, encryptAlg, null);
    }

    public static Future<EncryptOptions> reloadEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        return EncryptOptionsCache.reloadEncryptOptions("", "", appKey, encryptAlg, serverRoot);
    }

    public static Future<EncryptOptions> reloadEncryptOptions(String provider, String env, String appKey, String encryptAlg, String serverRoot) {
        try {
            ENCRYPT_OPTIONS_CACHE.invalidate((Object)EncryptOptionsCache.getCacheKey(provider, env, appKey, encryptAlg, serverRoot));
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, InvalidateEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", (Throwable)e);
        }
        return EncryptOptionsCache.loadEncryptOptions(provider, env, appKey, encryptAlg, serverRoot);
    }

    private static String getCacheKey(String provider, String env, String appKey, String encryptAlg, String serverRoot) {
        return StringUtils.joinWith((String)",", (Object[])new Object[]{StringUtils.defaultIfBlank((CharSequence)provider, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)env, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)"default"), StringUtils.defaultIfBlank((CharSequence)encryptAlg, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)serverRoot, (CharSequence)"")});
    }

    private static LoadingCache<String, Future<EncryptOptions>> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire.longValue(), timeUnit);
        }
        return cacheBuilder.build((CacheLoader)new CacheLoader<String, Future<EncryptOptions>>(){

            public Future<EncryptOptions> load(String cacheKey) throws Exception {
                LOGGER.debug("try to init encryptOptions for cacheKey:" + cacheKey);
                Future encryptOptions = null;
                try {
                    String[] split = StringUtils.splitPreserveAllTokens((String)cacheKey, (String)",");
                    String provider = split[0];
                    String env = split[1];
                    String appKey = split[2];
                    String encryptAlg = split[3];
                    String serverRoot = split.length > 4 ? split[4] : null;
                    YopEncryptor encryptor = YopEncryptorFactory.getEncryptor(encryptAlg);
                    List<EncryptOptionsEnhancer> enhancers = Collections.singletonList(EncryptOptionsCache.getEnhancer(provider, env, appKey, encryptAlg, serverRoot));
                    encryptOptions = encryptor.initOptions(encryptAlg, enhancers);
                }
                catch (Exception ex) {
                    LOGGER.warn("UnexpectedException occurred when init encryptOptions for cacheKey:" + cacheKey, (Throwable)ex);
                }
                return encryptOptions;
            }
        });
    }

    private static EncryptOptionsEnhancer getEnhancer(String provider, String env, String appKey, String encryptAlg, String serverRoot) {
        switch (encryptAlg) {
            case "SM4/CBC/PKCS5Padding": {
                return new Sm2Enhancer(provider, env, appKey, "", serverRoot);
            }
            case "AES": 
            case "AES/ECB/PKCS5Padding": {
                return new RsaEnhancer(provider, env, appKey);
            }
        }
        throw new YopClientException("not supported encryptAlg:" + encryptAlg);
    }
}

